/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.annotation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import picard.annotation.AnnotationException;
import picard.annotation.Gene;

public class GeneFromGTF
extends Gene
implements Iterable<Gene.Transcript> {
    private final String geneID;
    private final String transcriptType;
    private final String featureType;
    private final Integer geneVersion;
    private final Map<String, TranscriptFromGTF> transcripts = new HashMap<String, TranscriptFromGTF>();

    public GeneFromGTF(String sequence, int start, int end, boolean negative, String name, String featureType, String geneID, String transcriptType, Integer geneVersion) {
        super(sequence, start, end, negative, name);
        this.featureType = featureType;
        this.geneID = geneID;
        this.transcriptType = transcriptType;
        this.geneVersion = geneVersion;
    }

    public String getGeneID() {
        return this.geneID;
    }

    public String getTranscriptType() {
        return this.transcriptType;
    }

    public String getFeatureType() {
        return this.featureType;
    }

    public Integer getGeneVersion() {
        return this.geneVersion;
    }

    @Override
    public Iterator<Gene.Transcript> iterator() {
        return this.transcripts.values().iterator();
    }

    public Collection<TranscriptFromGTF> getTranscripts() {
        return this.transcripts.values();
    }

    public TranscriptFromGTF addTranscript(String name, int transcriptionStart, int transcriptionEnd, int codingStart, int codingEnd, int numExons, String transcriptName, String transcriptID, String transcriptType) {
        if (this.transcripts.containsKey(name)) {
            throw new AnnotationException("Transcript " + name + " for gene " + this.getName() + " appears more than once");
        }
        TranscriptFromGTF tx = new TranscriptFromGTF(name, transcriptionStart, transcriptionEnd, codingStart, codingEnd, numExons, transcriptName, transcriptID, transcriptType);
        this.transcripts.put(name, tx);
        return tx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneFromGTF that = (GeneFromGTF)o;
        if (this.getStart() != that.getStart()) {
            return false;
        }
        if (this.getEnd() != that.getEnd()) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (!this.getContig().equals(that.getContig())) {
            return false;
        }
        return this.getGeneID().equals(that.getGeneID());
    }

    public int hashCode() {
        int result = this.getContig().hashCode();
        result = 31 * result + this.getStart();
        result = 31 * result + this.getEnd();
        result = 31 * result + this.getName().hashCode();
        return result;
    }

    public class TranscriptFromGTF
    extends Gene.Transcript {
        private final String transcriptName;
        private final String transcriptID;
        private final String transcriptType;

        public TranscriptFromGTF(String name, int transcriptionStart, int transcriptionEnd, int codingStart, int codingEnd, int numExons, String transcriptName, String transcriptID, String transcriptType) {
            super((Gene)GeneFromGTF.this, name, transcriptionStart, transcriptionEnd, codingStart, codingEnd, numExons);
            this.transcriptName = transcriptName;
            this.transcriptID = transcriptID;
            this.transcriptType = transcriptType;
        }

        public String getTranscriptName() {
            return this.transcriptName;
        }

        public String getTranscriptID() {
            return this.transcriptID;
        }

        public String getTranscriptType() {
            return this.transcriptType;
        }

        public GeneFromGTF getGene() {
            return GeneFromGTF.this;
        }
    }
}

