/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.Iterator;
import org.apache.commons.collections4.ArrayStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushbackIterator<E>
implements Iterator<E> {
    private final Iterator<? extends E> iterator;
    private ArrayStack<E> items = new ArrayStack();

    public static <E> PushbackIterator<E> pushbackIterator(Iterator<? extends E> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("Iterator must not be null");
        }
        if (iterator instanceof PushbackIterator) {
            PushbackIterator it = (PushbackIterator)iterator;
            return it;
        }
        return new PushbackIterator<E>(iterator);
    }

    public PushbackIterator(Iterator<? extends E> iterator) {
        this.iterator = iterator;
    }

    public void pushback(E item) {
        this.items.push(item);
    }

    @Override
    public boolean hasNext() {
        return !this.items.isEmpty() ? true : this.iterator.hasNext();
    }

    @Override
    public E next() {
        return !this.items.isEmpty() ? this.items.pop() : this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

