/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix;

import java.util.Iterator;
import java.util.Random;
import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.iterator.ColumnMajorMatrixIterator;
import org.la4j.iterator.MatrixIterator;
import org.la4j.matrix.RowMajorSparseMatrix;
import org.la4j.matrix.SparseMatrix;
import org.la4j.matrix.sparse.CCSMatrix;
import org.la4j.operation.MatrixMatrixOperation;
import org.la4j.operation.MatrixOperation;
import org.la4j.operation.MatrixVectorOperation;

public abstract class ColumnMajorSparseMatrix
extends SparseMatrix {
    public static ColumnMajorSparseMatrix zero(int rows, int columns) {
        return CCSMatrix.zero(rows, columns);
    }

    public static ColumnMajorSparseMatrix zero(int rows, int columns, int capacity) {
        return CCSMatrix.zero(rows, columns, capacity);
    }

    public static ColumnMajorSparseMatrix diagonal(int size, double diagonal) {
        return CCSMatrix.diagonal(size, diagonal);
    }

    public static ColumnMajorSparseMatrix identity(int size) {
        return CCSMatrix.identity(size);
    }

    public static ColumnMajorSparseMatrix random(int rows, int columns, double density, Random random) {
        return CCSMatrix.random(rows, columns, density, random);
    }

    public static ColumnMajorSparseMatrix randomSymmetric(int size, double density, Random random) {
        return CCSMatrix.randomSymmetric(size, density, random);
    }

    public static ColumnMajorSparseMatrix from1DArray(int rows, int columns, double[] array) {
        return CCSMatrix.from1DArray(rows, columns, array);
    }

    public static ColumnMajorSparseMatrix from2DArray(double[][] array) {
        return CCSMatrix.from2DArray(array);
    }

    public static ColumnMajorSparseMatrix block(Matrix a, Matrix b, Matrix c, Matrix d) {
        return CCSMatrix.block(a, b, c, d);
    }

    public static ColumnMajorSparseMatrix fromCSV(String csv) {
        return Matrix.fromCSV(csv).to(Matrices.SPARSE_COLUMN_MAJOR);
    }

    public static ColumnMajorSparseMatrix fromMatrixMarket(String mm) {
        return Matrix.fromMatrixMarket(mm).to(Matrices.SPARSE_COLUMN_MAJOR);
    }

    public ColumnMajorSparseMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public ColumnMajorSparseMatrix(int rows, int columns, int cardinality) {
        super(rows, columns, cardinality);
    }

    @Override
    public boolean isRowMajor() {
        return false;
    }

    @Override
    public Matrix transpose() {
        RowMajorSparseMatrix result = RowMajorSparseMatrix.zero(this.columns, this.rows);
        ColumnMajorMatrixIterator it = this.nonZeroColumnMajorIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            result.set(j, i, x);
        }
        return result;
    }

    @Override
    public Matrix rotate() {
        RowMajorSparseMatrix result = RowMajorSparseMatrix.zero(this.columns, this.rows);
        ColumnMajorMatrixIterator it = this.nonZeroColumnMajorIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            result.set(j, this.rows - 1 - i, x);
        }
        return result;
    }

    @Override
    public ColumnMajorMatrixIterator iterator() {
        return this.columnMajorIterator();
    }

    @Override
    public MatrixIterator nonZeroIterator() {
        return this.nonZeroColumnMajorIterator();
    }

    public abstract Iterator<Integer> iteratorOrNonZeroColumns();

    @Override
    public <T> T apply(MatrixOperation<T> operation) {
        operation.ensureApplicableTo(this);
        return operation.apply(this);
    }

    @Override
    public <T> T apply(MatrixMatrixOperation<T> operation, Matrix that) {
        return that.apply(operation.partiallyApply(this));
    }

    @Override
    public <T> T apply(MatrixVectorOperation<T> operation, Vector that) {
        return that.apply(operation.partiallyApply(this));
    }
}

