/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import htsjdk.samtools.util.IterableOnceIterator;
import htsjdk.samtools.util.PeekableIterator;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;

public class PeekableGroupingIterator<T>
extends IterableOnceIterator<T> {
    private final PeekableIterator<T> underlyingIterator;
    private final Comparator<T> comparator;
    private T last;
    private boolean inGroup = false;

    public PeekableGroupingIterator(Iterator<T> underlyingIterator, Comparator<T> comparator) {
        this.underlyingIterator = new PeekableIterator(underlyingIterator);
        this.comparator = comparator;
        this.inGroup = false;
    }

    public boolean hasNext() {
        return this.underlyingIterator.hasNext();
    }

    public boolean hasNextInGroup() {
        if (this.last == null && this.underlyingIterator.hasNext()) {
            return true;
        }
        if (!this.underlyingIterator.hasNext()) {
            return false;
        }
        Object next = this.underlyingIterator.peek();
        int cmp = this.comparator.compare(this.last, next);
        if (cmp == 0) {
            return true;
        }
        if (cmp > 0) {
            throw new IllegalStateException(String.format("Out of order iterator: %s > %s", this.last.toString(), next.toString()));
        }
        return false;
    }

    public T next() {
        this.last = this.underlyingIterator.next();
        return this.last;
    }

    public void close() throws IOException {
        this.underlyingIterator.close();
        super.close();
    }
}

