/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.readiterators;

import htsjdk.samtools.SAMRecord;
import java.util.Iterator;
import org.broadinstitute.dropseqrna.utils.FilteredIterator;
import org.broadinstitute.dropseqrna.utils.ObjectCounter;

public class BamTagCountingIterator
extends FilteredIterator<SAMRecord> {
    private String tag;
    private ObjectCounter<String> counter;

    public BamTagCountingIterator(Iterator<SAMRecord> underlyingIterator, String tag) {
        super(underlyingIterator);
        if (tag != null) {
            this.counter = new ObjectCounter();
        }
        this.tag = tag;
    }

    @Override
    public boolean filterOut(SAMRecord rec) {
        if (this.tag == null) {
            return false;
        }
        String value = rec.getStringAttribute(this.tag);
        if (value != null) {
            this.counter.increment(value);
        }
        return false;
    }

    public ObjectCounter<String> getCounts() {
        return this.counter;
    }
}

