/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.alignment.SimpleAlignedSequence;
import org.biojava.nbio.alignment.SubstitutionMatrixHelper;
import org.biojava.nbio.alignment.template.AlignedSequence;
import org.biojava.nbio.alignment.template.Profile;
import org.biojava.nbio.alignment.template.ProfileView;
import org.biojava.nbio.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.io.util.IOUtils;
import org.biojava.nbio.core.sequence.location.template.Location;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;

public class SimpleProfile<S extends Sequence<C>, C extends Compound>
implements Profile<S, C> {
    private List<AlignedSequence<S, C>> list;
    private List<S> originals;
    private int length;
    protected static final SubstitutionMatrix<AminoAcidCompound> matrix = SubstitutionMatrixHelper.getBlosum65();

    protected SimpleProfile(AlignedSequence<S, C> query, AlignedSequence<S, C> target) {
        if (query.getLength() != target.getLength()) {
            throw new IllegalArgumentException("Aligned sequences differ in size");
        }
        this.list = new ArrayList<AlignedSequence<S, C>>();
        this.list.add(query);
        this.list.add(target);
        this.list = Collections.unmodifiableList(this.list);
        this.originals = new ArrayList<S>();
        this.originals.add(query.getOriginalSequence());
        this.originals.add(target.getOriginalSequence());
        this.originals = Collections.unmodifiableList(this.originals);
        this.length = query.getLength();
    }

    public SimpleProfile(S sequence) {
        ArrayList<AlignedSequence.Step> s = new ArrayList<AlignedSequence.Step>();
        for (int i = 0; i < sequence.getLength(); ++i) {
            s.add(AlignedSequence.Step.COMPOUND);
        }
        this.list = new ArrayList<AlignedSequence<S, C>>();
        this.list.add(new SimpleAlignedSequence(sequence, s));
        this.list = Collections.unmodifiableList(this.list);
        this.originals = new ArrayList<S>();
        this.originals.add(sequence);
        this.originals = Collections.unmodifiableList(this.originals);
        this.length = sequence.getLength();
    }

    protected SimpleProfile(S query, S target, List<AlignedSequence.Step> sx, int xb, int xa, List<AlignedSequence.Step> sy, int yb, int ya) {
        if (sx.size() != sy.size()) {
            throw new IllegalArgumentException("Alignments differ in size");
        }
        this.list = new ArrayList<AlignedSequence<S, C>>();
        this.list.add(new SimpleAlignedSequence(query, sx, xb, xa));
        this.list.add(new SimpleAlignedSequence(target, sy, yb, ya));
        this.list = Collections.unmodifiableList(this.list);
        this.originals = new ArrayList<S>();
        this.originals.add(query);
        this.originals.add(target);
        this.originals = Collections.unmodifiableList(this.originals);
        this.length = sx.size();
    }

    protected SimpleProfile(Profile<S, C> query, Profile<S, C> target, List<AlignedSequence.Step> sx, List<AlignedSequence.Step> sy) {
        if (sx.size() != sy.size()) {
            throw new IllegalArgumentException("Alignments differ in size");
        }
        this.list = new ArrayList<AlignedSequence<S, C>>();
        for (AlignedSequence alignedSequence : query) {
            this.list.add(new SimpleAlignedSequence(alignedSequence, sx));
        }
        for (AlignedSequence alignedSequence : target) {
            this.list.add(new SimpleAlignedSequence(alignedSequence, sy));
        }
        this.list = Collections.unmodifiableList(this.list);
        this.originals = new ArrayList<S>();
        this.originals.addAll(query.getOriginalSequences());
        this.originals.addAll(target.getOriginalSequences());
        this.originals = Collections.unmodifiableList(this.originals);
        this.length = sx.size();
    }

    public SimpleProfile(Collection<AlignedSequence<S, C>> alignedSequences) {
        this.list = new ArrayList<AlignedSequence<S, C>>();
        this.originals = new ArrayList<S>();
        Iterator<AlignedSequence<S, C>> itr = alignedSequences.iterator();
        if (!itr.hasNext()) {
            throw new IllegalArgumentException("alignedSequences must not be empty");
        }
        AlignedSequence<S, C> curAlignedSeq = itr.next();
        this.length = curAlignedSeq.getLength();
        this.list.add(curAlignedSeq);
        this.originals.add(curAlignedSeq.getOriginalSequence());
        while (itr.hasNext()) {
            curAlignedSeq = itr.next();
            if (curAlignedSeq.getLength() != this.length) {
                throw new IllegalArgumentException("Aligned sequences differ in size");
            }
            this.list.add(curAlignedSeq);
            this.originals.add(curAlignedSeq.getOriginalSequence());
        }
        this.list = Collections.unmodifiableList(this.list);
        this.originals = Collections.unmodifiableList(this.originals);
    }

    @Override
    public AlignedSequence<S, C> getAlignedSequence(int listIndex) {
        return this.list.get(listIndex - 1);
    }

    @Override
    public AlignedSequence<S, C> getAlignedSequence(S sequence) {
        for (AlignedSequence<S, C> s : this.list) {
            if (!s.equals(sequence) && !s.getOriginalSequence().equals(sequence)) continue;
            return s;
        }
        return null;
    }

    @Override
    public List<AlignedSequence<S, C>> getAlignedSequences() {
        return this.list;
    }

    @Override
    public List<AlignedSequence<S, C>> getAlignedSequences(int ... listIndices) {
        ArrayList<AlignedSequence<int, C>> tempList = new ArrayList<AlignedSequence<int, C>>();
        for (int i : listIndices) {
            tempList.add(this.getAlignedSequence((S)i));
        }
        return Collections.unmodifiableList(tempList);
    }

    @Override
    public List<AlignedSequence<S, C>> getAlignedSequences(S ... sequences) {
        ArrayList<AlignedSequence<S, C>> tempList = new ArrayList<AlignedSequence<S, C>>();
        for (S s : sequences) {
            tempList.add(this.getAlignedSequence(s));
        }
        return Collections.unmodifiableList(tempList);
    }

    @Override
    public C getCompoundAt(int listIndex, int alignmentIndex) {
        return (C)this.getAlignedSequence((S)listIndex).getCompoundAt(alignmentIndex);
    }

    @Override
    public C getCompoundAt(S sequence, int alignmentIndex) {
        AlignedSequence<S, C> s = this.getAlignedSequence(sequence);
        return (C)(s == null ? null : s.getCompoundAt(alignmentIndex));
    }

    @Override
    public int[] getCompoundCountsAt(int alignmentIndex) {
        return this.getCompoundCountsAt(alignmentIndex, this.getCompoundSet().getAllCompounds());
    }

    @Override
    public int[] getCompoundCountsAt(int alignmentIndex, List<C> compounds) {
        int[] counts = new int[compounds.size()];
        Compound gap = this.getCompoundSet().getCompoundForString("-");
        int igap = compounds.indexOf(gap);
        for (Compound compound : this.getCompoundsAt(alignmentIndex)) {
            int i = compounds.indexOf(compound);
            if (i < 0 || i == igap || this.getCompoundSet().compoundsEquivalent(compound, gap)) continue;
            int n = i;
            counts[n] = counts[n] + 1;
        }
        return counts;
    }

    @Override
    public List<C> getCompoundsAt(int alignmentIndex) {
        ArrayList<Compound> column = new ArrayList<Compound>();
        for (AlignedSequence<S, C> s : this.list) {
            column.add(s.getCompoundAt(alignmentIndex));
        }
        return Collections.unmodifiableList(column);
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        return this.list.get(0).getCompoundSet();
    }

    @Override
    public float[] getCompoundWeightsAt(int alignmentIndex) {
        return this.getCompoundWeightsAt(alignmentIndex, this.getCompoundSet().getAllCompounds());
    }

    @Override
    public float[] getCompoundWeightsAt(int alignmentIndex, List<C> compounds) {
        float[] weights = new float[compounds.size()];
        int[] counts = this.getCompoundCountsAt(alignmentIndex, compounds);
        float total = 0.0f;
        for (int i : counts) {
            total += (float)i;
        }
        if (total > 0.0f) {
            for (int i = 0; i < weights.length; ++i) {
                weights[i] = (float)counts[i] / total;
            }
        }
        return weights;
    }

    @Override
    public int getIndexOf(C compound) {
        for (int i = 1; i <= this.length; ++i) {
            if (!this.getCompoundsAt(i).contains(compound)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int[] getIndicesAt(int alignmentIndex) {
        int[] indices = new int[this.list.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.list.get(i).getSequenceIndexAt(alignmentIndex);
        }
        return indices;
    }

    @Override
    public int getLastIndexOf(C compound) {
        for (int i = this.length; i >= 1; --i) {
            if (!this.getCompoundsAt(i).contains(compound)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public List<S> getOriginalSequences() {
        return this.originals;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (AlignedSequence<S, C> s : this.list) {
            size += s.getOverlapCount();
        }
        return size;
    }

    @Override
    public ProfileView<S, C> getSubProfile(Location location) {
        return null;
    }

    @Override
    public boolean hasGap(int alignmentIndex) {
        Compound gap = this.getCompoundSet().getCompoundForString("-");
        for (Compound compound : this.getCompoundsAt(alignmentIndex)) {
            if (!this.getCompoundSet().compoundsEquivalent(compound, gap)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCircular() {
        for (AlignedSequence<S, C> s : this.list) {
            if (!s.isCircular()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString(int width) {
        return this.toString(width, null, IOUtils.getIDFormat(this.list), true, true, true, true, true, false);
    }

    @Override
    public String toString(Profile.StringFormat format) {
        switch (format) {
            default: {
                return this.toString(60, String.format("CLUSTAL W MSA from BioJava%n%n", new Object[0]), IOUtils.getIDFormat(this.list) + "   ", false, true, true, false, true, false);
            }
            case FASTA: {
                return this.toString(60, null, ">%s%n", false, false, false, false, false, false);
            }
            case GCG: 
            case MSF: {
                return this.toString(50, IOUtils.getGCGHeader(this.list), IOUtils.getIDFormat(this.list), false, false, true, false, false, false);
            }
            case PDBWEB: 
        }
        return this.toString(60, null, "%10s", true, true, true, false, true, true);
    }

    @Override
    public String toString() {
        return this.toString(this.getLength(), null, null, false, false, false, false, false, false);
    }

    @Override
    public Iterator<AlignedSequence<S, C>> iterator() {
        return this.list.iterator();
    }

    private String toString(int width, String header, String idFormat, boolean seqIndexPre, boolean seqIndexPost, boolean interlaced, boolean aligIndices, boolean aligConservation, boolean webDisplay) {
        StringBuilder s;
        StringBuilder stringBuilder = s = header == null ? new StringBuilder() : new StringBuilder(header);
        if (webDisplay && this.list.size() == 2) {
            s.append("<div><pre>");
        }
        width = Math.max(1, width);
        int seqIndexPad = (int)(Math.floor(Math.log10(this.getLength())) + 2.0);
        String seqIndexFormatPre = "%" + seqIndexPad + "d ";
        String seqIndexFormatPost = "%" + seqIndexPad + "d";
        if (interlaced) {
            String aligIndFormat = "%-" + Math.max(1, width / 2) + "d %" + Math.max(1, width - width / 2 - 1) + "d%n";
            for (int i = 0; i < this.getLength(); i += width) {
                int start = i + 1;
                int end = Math.min(this.getLength(), i + width);
                if (i > 0) {
                    s.append(String.format("%n", new Object[0]));
                }
                if (aligIndices) {
                    if (end < i + width) {
                        int line = end - start + 1;
                        aligIndFormat = "%-" + Math.max(1, line / 2) + "d %" + Math.max(1, line - line / 2 - 1) + "d%n";
                    }
                    if (idFormat != null) {
                        s.append(String.format(idFormat, ""));
                    }
                    if (seqIndexPre) {
                        s.append(String.format("%" + (seqIndexPad + 1) + "s", ""));
                    }
                    s.append(String.format(aligIndFormat, start, end));
                }
                int counter = 0;
                for (AlignedSequence<S, C> as : this.list) {
                    ++counter;
                    if (webDisplay && this.list.size() == 2) {
                        this.printSequenceAlignmentWeb(s, counter, idFormat, seqIndexPre, seqIndexFormatPre, seqIndexPost, seqIndexFormatPost, start, end);
                    } else {
                        if (idFormat != null) {
                            s.append(String.format(idFormat, as.getAccession()));
                        }
                        if (seqIndexPre) {
                            s.append(String.format(seqIndexFormatPre, as.getSequenceIndexAt(start)));
                        }
                        s.append(as.getSubSequence(start, end).getSequenceAsString());
                        if (seqIndexPost) {
                            s.append(String.format(seqIndexFormatPost, as.getSequenceIndexAt(end)));
                        }
                        s.append(String.format("%n", new Object[0]));
                    }
                    if (!aligConservation || this.list.size() != 2 || counter != 1) continue;
                    this.printConservation(s, idFormat, seqIndexPad, seqIndexPre, start, end, webDisplay);
                }
            }
        } else {
            for (AlignedSequence<S, C> as : this.list) {
                if (idFormat != null) {
                    s.append(String.format(idFormat, as.getAccession()));
                }
                for (int i = 0; i < this.getLength(); i += width) {
                    int start = i + 1;
                    int end = Math.min(this.getLength(), i + width);
                    if (seqIndexPre) {
                        s.append(String.format(seqIndexFormatPre, as.getSequenceIndexAt(start)));
                    }
                    s.append(as.getSubSequence(start, end).getSequenceAsString());
                    if (seqIndexPost) {
                        s.append(String.format(seqIndexFormatPost, as.getSequenceIndexAt(end)));
                    }
                    s.append(String.format("%n", new Object[0]));
                }
            }
        }
        if (webDisplay && aligConservation && this.list.size() == 2) {
            s.append(IOUtils.getPDBLegend());
        }
        return s.toString();
    }

    private void printSequenceAlignmentWeb(StringBuilder s, int counter, String idFormat, boolean seqIndexPre, String seqIndexFormatPre, boolean seqIndexPost, String seqIndexFormatPost, int start, int end) {
        AlignedSequence<S, C> as1 = this.list.get(0);
        AlignedSequence<S, C> as2 = this.list.get(1);
        AlignedSequence<S, C> as = this.list.get(counter - 1);
        if (idFormat != null) {
            s.append(String.format(idFormat, as.getAccession()));
        }
        if (seqIndexPre) {
            s.append(String.format(seqIndexFormatPre, as.getSequenceIndexAt(start)));
        }
        String mySeq = as.getSubSequence(start, end).getSequenceAsString();
        String s1 = as1.getSubSequence(start, end).getSequenceAsString();
        String s2 = as2.getSubSequence(start, end).getSequenceAsString();
        for (int i = 0; i < s1.length() && i < s2.length() && i < mySeq.length(); ++i) {
            char c1 = s1.charAt(i);
            char c2 = s2.charAt(i);
            char c = mySeq.charAt(i);
            s.append(IOUtils.getPDBCharacter((boolean)true, (char)c1, (char)c2, (boolean)this.isSimilar(c1, c2), (char)c));
        }
        if (seqIndexPost) {
            s.append(String.format(seqIndexFormatPost, as.getSequenceIndexAt(end)));
        }
        s.append(String.format("%n", new Object[0]));
    }

    private void printConservation(StringBuilder s, String idFormat, int seqIndexPad, boolean seqIndexPre, int start, int end, boolean webDisplay) {
        AlignedSequence<S, C> as1 = this.list.get(0);
        AlignedSequence<S, C> as2 = this.list.get(1);
        if (idFormat != null) {
            AccessionID ac1 = as1.getAccession();
            String id1 = ac1 == null ? "null" : ac1.getID();
            id1 = id1.replaceAll(".", " ");
            s.append(String.format(idFormat, id1));
        }
        if (seqIndexPre) {
            s.append(String.format("%" + (seqIndexPad + 1) + "s", ""));
        }
        String subseq1 = as1.getSubSequence(start, end).getSequenceAsString();
        String subseq2 = as2.getSubSequence(start, end).getSequenceAsString();
        for (int ii = 0; ii < subseq1.length() && ii < subseq2.length(); ++ii) {
            char c1 = subseq1.charAt(ii);
            char c2 = subseq2.charAt(ii);
            s.append(IOUtils.getPDBConservation((boolean)webDisplay, (char)c1, (char)c2, (boolean)this.isSimilar(c1, c2)));
        }
        s.append(String.format("%n", new Object[0]));
    }

    private boolean isSimilar(char c1, char c2) {
        AminoAcidCompound aa2;
        AminoAcidCompoundSet set = AminoAcidCompoundSet.getAminoAcidCompoundSet();
        AminoAcidCompound aa1 = set.getCompoundForString("" + c1);
        short val = matrix.getValue(aa1, aa2 = set.getCompoundForString("" + c2));
        return val > 0;
    }
}

