/*
 * Decompiled with CFR 0.152.
 */
package org.la4j;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.la4j.LinearAlgebra;
import org.la4j.vector.VectorFactory;
import org.la4j.vector.dense.BasicVector;
import org.la4j.vector.functor.VectorAccumulator;
import org.la4j.vector.functor.VectorFunction;
import org.la4j.vector.functor.VectorPredicate;
import org.la4j.vector.functor.VectorProcedure;
import org.la4j.vector.sparse.CompressedVector;

public final class Vectors {
    public static final double EPS = LinearAlgebra.EPS;
    public static final int ROUND_FACTOR = LinearAlgebra.ROUND_FACTOR;
    public static final VectorFactory<BasicVector> BASIC = new VectorFactory<BasicVector>(){

        @Override
        public BasicVector apply(int length) {
            return BasicVector.zero(length);
        }
    };
    public static final VectorFactory<CompressedVector> COMPRESSED = new VectorFactory<CompressedVector>(){

        @Override
        public CompressedVector apply(int length) {
            return CompressedVector.zero(length);
        }
    };
    public static final VectorFactory[] FACTORIES = new VectorFactory[]{BASIC, COMPRESSED};
    public static final VectorFactory<BasicVector> DENSE = BASIC;
    public static final VectorFactory<CompressedVector> SPARSE = COMPRESSED;
    public static final VectorPredicate ZERO_VECTOR = new VectorPredicate(){

        @Override
        public boolean test(int i, double value) {
            return Math.abs(value) < EPS;
        }
    };
    public static final VectorPredicate POSITIVE_VECTOR = new VectorPredicate(){

        @Override
        public boolean test(int i, double value) {
            return value > 0.0;
        }
    };
    public static final VectorPredicate NEGATIVE_VECTOR = new VectorPredicate(){

        @Override
        public boolean test(int i, double value) {
            return value < 0.0;
        }
    };
    public static final VectorFunction INC_FUNCTION = new VectorFunction(){

        @Override
        public double evaluate(int i, double value) {
            return value + 1.0;
        }
    };
    public static final VectorFunction DEC_FUNCTION = new VectorFunction(){

        @Override
        public double evaluate(int i, double value) {
            return value - 1.0;
        }
    };
    public static final VectorFunction INV_FUNCTION = new VectorFunction(){

        @Override
        public double evaluate(int i, double value) {
            return -value;
        }
    };

    public static VectorFunction asConstFunction(final double arg) {
        return new VectorFunction(){

            @Override
            public double evaluate(int i, double value) {
                return arg;
            }
        };
    }

    public static VectorFunction asPlusFunction(final double arg) {
        return new VectorFunction(){

            @Override
            public double evaluate(int i, double value) {
                return value + arg;
            }
        };
    }

    public static VectorFunction asMinusFunction(final double arg) {
        return new VectorFunction(){

            @Override
            public double evaluate(int i, double value) {
                return value - arg;
            }
        };
    }

    public static VectorFunction asMulFunction(final double arg) {
        return new VectorFunction(){

            @Override
            public double evaluate(int i, double value) {
                return value * arg;
            }
        };
    }

    public static VectorFunction asDivFunction(final double arg) {
        return new VectorFunction(){

            @Override
            public double evaluate(int i, double value) {
                return value / arg;
            }
        };
    }

    public static VectorFunction asModFunction(final double arg) {
        return new VectorFunction(){

            @Override
            public double evaluate(int i, double value) {
                return value % arg;
            }
        };
    }

    public static VectorAccumulator asSumAccumulator(final double neutral) {
        return new VectorAccumulator(){
            private BigDecimal result;
            {
                this.result = new BigDecimal(neutral);
            }

            @Override
            public void update(int i, double value) {
                this.result = this.result.add(new BigDecimal(value));
            }

            @Override
            public double accumulate() {
                double value = this.result.setScale(ROUND_FACTOR, RoundingMode.CEILING).doubleValue();
                this.result = new BigDecimal(neutral);
                return value;
            }
        };
    }

    public static VectorAccumulator asProductAccumulator(final double neutral) {
        return new VectorAccumulator(){
            private BigDecimal result;
            {
                this.result = new BigDecimal(neutral);
            }

            @Override
            public void update(int i, double value) {
                this.result = this.result.multiply(new BigDecimal(value));
            }

            @Override
            public double accumulate() {
                double value = this.result.setScale(ROUND_FACTOR, RoundingMode.CEILING).doubleValue();
                this.result = new BigDecimal(neutral);
                return value;
            }
        };
    }

    public static VectorAccumulator mkMinAccumulator() {
        return new VectorAccumulator(){
            private double result = Double.POSITIVE_INFINITY;

            @Override
            public void update(int i, double value) {
                this.result = Math.min(this.result, value);
            }

            @Override
            public double accumulate() {
                double value = this.result;
                this.result = Double.POSITIVE_INFINITY;
                return value;
            }
        };
    }

    public static VectorAccumulator mkMaxAccumulator() {
        return new VectorAccumulator(){
            private double result = Double.NEGATIVE_INFINITY;

            @Override
            public void update(int i, double value) {
                this.result = Math.max(this.result, value);
            }

            @Override
            public double accumulate() {
                double value = this.result;
                this.result = Double.NEGATIVE_INFINITY;
                return value;
            }
        };
    }

    public static VectorAccumulator mkEuclideanNormAccumulator() {
        return new VectorAccumulator(){
            private BigDecimal result = new BigDecimal(0.0);

            @Override
            public void update(int i, double value) {
                this.result = this.result.add(new BigDecimal(value * value));
            }

            @Override
            public double accumulate() {
                double value = this.result.setScale(ROUND_FACTOR, RoundingMode.CEILING).doubleValue();
                this.result = new BigDecimal(0.0);
                return Math.sqrt(value);
            }
        };
    }

    public static VectorAccumulator mkManhattanNormAccumulator() {
        return new VectorAccumulator(){
            private double result = 0.0;

            @Override
            public void update(int i, double value) {
                this.result += Math.abs(value);
            }

            @Override
            public double accumulate() {
                double value = this.result;
                this.result = 0.0;
                return value;
            }
        };
    }

    public static VectorAccumulator mkInfinityNormAccumulator() {
        return new VectorAccumulator(){
            private double result = Double.NEGATIVE_INFINITY;

            @Override
            public void update(int i, double value) {
                this.result = Math.max(this.result, Math.abs(value));
            }

            @Override
            public double accumulate() {
                double value = this.result;
                this.result = Double.NEGATIVE_INFINITY;
                return value;
            }
        };
    }

    public static VectorAccumulator asSumFunctionAccumulator(final double neutral, final VectorFunction function) {
        return new VectorAccumulator(){
            private final VectorAccumulator sumAccumulator;
            {
                this.sumAccumulator = Vectors.asSumAccumulator(neutral);
            }

            @Override
            public void update(int i, double value) {
                this.sumAccumulator.update(i, function.evaluate(i, value));
            }

            @Override
            public double accumulate() {
                return this.sumAccumulator.accumulate();
            }
        };
    }

    public static VectorAccumulator asProductFunctionAccumulator(final double neutral, final VectorFunction function) {
        return new VectorAccumulator(){
            private final VectorAccumulator productAccumulator;
            {
                this.productAccumulator = Vectors.asProductAccumulator(neutral);
            }

            @Override
            public void update(int i, double value) {
                this.productAccumulator.update(i, function.evaluate(i, value));
            }

            @Override
            public double accumulate() {
                return this.productAccumulator.accumulate();
            }
        };
    }

    public static VectorProcedure asAccumulatorProcedure(final VectorAccumulator accumulator) {
        return new VectorProcedure(){

            @Override
            public void apply(int i, double value) {
                accumulator.update(i, value);
            }
        };
    }
}

