/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.annotation;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.dropseqrna.cmdline.MetaData;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.util.TabbedTextFileWithHeaderParser;

@CommandLineProgramProperties(usage="Create standard Drop-seq intervals files: consensus_introns, genes, rRNA, exons, intergenic", usageShort="Create standard Drop-seq intervals files", programGroup=MetaData.class)
public class CreateIntervalsFiles
extends CommandLineProgram {
    @Option(shortName="SD", doc="The reference sequence dictionary.")
    public File SEQUENCE_DICTIONARY;
    @Option(doc="Gene definitions used to generate intervals files")
    public File REDUCED_GTF;
    @Option(shortName="O", doc="Directory where intervals files are written")
    public File OUTPUT;
    @Option(doc="intervals files are named using this prefix")
    public String PREFIX;
    @Option(doc="Name(s) of MT reference sequence, for creating mt.intervals file")
    public List<String> MT_SEQUENCE;
    @Option(doc="Name(s) of non-autosome reference sequences, for creating non_autosomes.intervals file")
    public List<String> NON_AUTOSOME_SEQUENCE;

    public static void main(String[] args) {
        new CreateIntervalsFiles().instanceMainWithExit(args);
    }

    protected int doWork() {
        IOUtil.assertDirectoryIsWritable((File)this.OUTPUT);
        SAMFileHeader samHeader = SamReaderFactory.makeDefault().open(this.SEQUENCE_DICTIONARY).getFileHeader();
        IntervalList genes = new IntervalList(samHeader);
        IntervalList exons = new IntervalList(samHeader);
        IntervalList consensusIntrons = new IntervalList(samHeader);
        IntervalList rRNA = new IntervalList(samHeader);
        IntervalList mtIntervals = this.MT_SEQUENCE.isEmpty() ? null : new IntervalList(CreateIntervalsFiles.createSubsetSamHeader(samHeader, this.MT_SEQUENCE));
        IntervalList nonAutosomeIntervals = this.NON_AUTOSOME_SEQUENCE.isEmpty() ? null : new IntervalList(CreateIntervalsFiles.createSubsetSamHeader(samHeader, this.NON_AUTOSOME_SEQUENCE));
        TabbedTextFileWithHeaderParser parser = new TabbedTextFileWithHeaderParser(this.REDUCED_GTF);
        for (Object row : parser) {
            try {
                String chr = row.getField(ReducedGtfColumn.chr.name());
                int start = Integer.parseInt(row.getField(ReducedGtfColumn.start.name()));
                int end = Integer.parseInt(row.getField(ReducedGtfColumn.end.name()));
                String annotationType = row.getField(ReducedGtfColumn.annotationType.name());
                String transcriptType = row.getField(ReducedGtfColumn.transcriptType.name());
                String strand = row.getField(ReducedGtfColumn.strand.name());
                String name = annotationType.equals(AnnotationType.gene.name()) ? row.getField(ReducedGtfColumn.gene_name.name()) : this.makeIntervalName(chr, start, end);
                Interval interval = new Interval(chr, start, end, strand.equals("-"), name);
                if (annotationType.equals(AnnotationType.gene.name())) {
                    genes.add(interval);
                    if (transcriptType.contains(TranscriptType.rRNA.name())) {
                        rRNA.add(interval);
                    }
                    if (!this.MT_SEQUENCE.contains(chr)) continue;
                    mtIntervals.add(interval);
                    continue;
                }
                if (annotationType.equals(AnnotationType.exon.name())) {
                    exons.add(interval);
                    continue;
                }
                if (!annotationType.equals(AnnotationType.consensus_intron.name())) continue;
                consensusIntrons.add(interval);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(String.format("Bad numeric value in file %s, line:\n %s", this.REDUCED_GTF.getAbsolutePath(), row.getCurrentLine()), e);
            }
        }
        CloserUtil.close((Object)parser);
        IntervalList genome = new IntervalList(samHeader);
        for (SAMSequenceRecord sequenceRecord : samHeader.getSequenceDictionary().getSequences()) {
            genome.add(new Interval(sequenceRecord.getSequenceName(), 1, sequenceRecord.getSequenceLength()));
        }
        IntervalList inverted = IntervalList.invert((IntervalList)genes);
        IntervalList intergenic = new IntervalList(samHeader);
        for (Interval interval : inverted.getIntervals()) {
            intergenic.add(new Interval(interval.getContig(), interval.getStart(), interval.getEnd(), false, this.makeIntervalName(interval.getContig(), interval.getStart(), interval.getEnd())));
        }
        this.write(genes, "genes");
        this.write(exons, "exons");
        this.write(consensusIntrons, "consensus_introns");
        this.write(rRNA, "rRNA");
        this.write(intergenic, "intergenic");
        if (mtIntervals != null) {
            this.write(mtIntervals, "mt");
        }
        if (nonAutosomeIntervals != null) {
            this.write(nonAutosomeIntervals, "non_autosomes");
        }
        return 0;
    }

    private SAMFileHeader createMtSamHeader(SAMFileHeader samHeader) {
        SAMFileHeader mtHeader = samHeader.clone();
        ArrayList<SAMSequenceRecord> mtSequences = new ArrayList<SAMSequenceRecord>(this.MT_SEQUENCE.size());
        for (String mtSequence : this.MT_SEQUENCE) {
            SAMSequenceRecord sequenceRecord = mtHeader.getSequence(mtSequence);
            if (sequenceRecord == null) {
                throw new RuntimeException("MT sequence '" + mtSequence + "' not found in sequence dictionary");
            }
            mtSequences.add(sequenceRecord);
        }
        mtHeader.getSequenceDictionary().setSequences(mtSequences);
        return mtHeader;
    }

    private static SAMFileHeader createSubsetSamHeader(SAMFileHeader samHeader, List<String> sequenceNames) {
        SAMFileHeader ret = samHeader.clone();
        ArrayList<SAMSequenceRecord> sequenceRecords = new ArrayList<SAMSequenceRecord>(sequenceNames.size());
        for (String sequence : sequenceNames) {
            SAMSequenceRecord sequenceRecord = ret.getSequence(sequence);
            if (sequenceRecord == null) {
                throw new RuntimeException("Sequence '" + sequence + "' specified on command line but not found in sequence dictionary");
            }
            sequenceRecords.add(sequenceRecord);
        }
        ret.getSequenceDictionary().setSequences(sequenceRecords);
        return ret;
    }

    private String makeIntervalName(String chr, int start, int end) {
        return String.format("%s:%d-%d", chr, start, end);
    }

    private void write(IntervalList list, String intervalType) {
        list.sorted().write(this.makeIntervalFile(intervalType));
    }

    private File makeIntervalFile(String intervalType) {
        return new File(this.OUTPUT, this.PREFIX + "." + intervalType + ".intervals");
    }

    private static enum TranscriptType {
        rRNA;

    }

    private static enum AnnotationType {
        gene,
        exon,
        consensus_intron;

    }

    private static enum ReducedGtfColumn {
        chr,
        start,
        end,
        annotationType,
        transcriptType,
        strand,
        gene_name;

    }
}

