/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.metrics;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.util.Histogram;

public class ReadQualityMetrics
extends MetricBase {
    public String aggregate = "";
    public long totalReads;
    public long mappedReads;
    public long hqMappedReads;
    public long hqMappedReadsNoPCRDupes;
    private Histogram<Integer> histogram = null;
    private int mapQuality;

    public ReadQualityMetrics(int mapQuality, String aggregate, boolean gatherQualityHistogram) {
        this.mapQuality = mapQuality;
        this.aggregate = aggregate;
        if (gatherQualityHistogram) {
            this.histogram = new Histogram("read quality", "num reads");
        }
    }

    public ReadQualityMetrics() {
    }

    public Histogram<Integer> getHistogram() {
        return this.histogram;
    }

    public void addRead(SAMRecord r) {
        if (r.isSecondaryOrSupplementary()) {
            return;
        }
        boolean isDupe = r.getDuplicateReadFlag();
        int mapQuality = r.getMappingQuality();
        boolean unmapped = r.getReadUnmappedFlag();
        if (this.histogram != null) {
            this.histogram.increment((Comparable)Integer.valueOf(mapQuality));
        }
        ++this.totalReads;
        if (!unmapped) {
            ++this.mappedReads;
            if (mapQuality >= this.mapQuality) {
                ++this.hqMappedReads;
                if (!isDupe) {
                    ++this.hqMappedReadsNoPCRDupes;
                }
            }
        }
    }
}

