/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Iterator;
import org.broadinstitute.dropseqrna.utils.FilteredIterator;

public class VariantContextSingletonFilter
extends FilteredIterator<VariantContext> {
    private final boolean hetVarOnly;

    public VariantContextSingletonFilter(Iterator<VariantContext> underlyingIterator, boolean hetVarOnly) {
        super(underlyingIterator);
        this.hetVarOnly = hetVarOnly;
    }

    @Override
    public boolean filterOut(VariantContext rec) {
        GenotypesContext gc = rec.getGenotypes();
        Iterator iter = gc.iterator();
        int count = 0;
        while (iter.hasNext()) {
            Genotype g = (Genotype)iter.next();
            if (this.hetVarOnly & g.isHomVar()) {
                return true;
            }
            if (!g.isHet() && !g.isHomVar()) continue;
            ++count;
        }
        return count != true;
    }
}

