/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.editdistance;

import org.broadinstitute.dropseqrna.utils.editdistance.LevenshteinDistanceResult;

public class LevenshteinDistance {
    private static int minimum(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static int getDistance(String str1, String str2) {
        return LevenshteinDistance.computeLevenshteinDistanceResult(str1, str2).getEditDistance();
    }

    public static int getDistance(String str1, String str2, int deletionCost, int insertionCost, int substitutionCost) {
        return LevenshteinDistance.computeLevenshteinDistanceResult(str1, str2, deletionCost, insertionCost, substitutionCost).getEditDistance();
    }

    public static LevenshteinDistanceResult computeLevenshteinDistanceResult(String str1, String str2) {
        return LevenshteinDistance.computeLevenshteinDistanceResult(str1, str2, 1, 1, 1);
    }

    public static LevenshteinDistanceResult computeLevenshteinDistanceResult(String str1, String str2, int deletionCost, int insertionCost, int substitutionCost) {
        int i;
        int[][] distance = new int[str1.length() + 1][str2.length() + 1];
        for (i = 0; i <= str1.length(); ++i) {
            distance[i][0] = i;
        }
        for (int j = 1; j <= str2.length(); ++j) {
            distance[0][j] = j;
        }
        for (i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                int value;
                int iCost = distance[i - 1][j] + deletionCost;
                int dCost = distance[i][j - 1] + insertionCost;
                int sCost = distance[i - 1][j - 1] + (str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : substitutionCost);
                distance[i][j] = value = LevenshteinDistance.minimum(iCost, dCost, sCost);
            }
        }
        LevenshteinDistanceResult r = new LevenshteinDistanceResult(str1, str2, distance, deletionCost, insertionCost, substitutionCost);
        return r;
    }

    public static int getIndelSlidingWindowEditDistance(String str1, String str2) {
        return LevenshteinDistance.getIndelSlidingWindowEditDistance(str1, str2, Math.max(str1.length(), str2.length()));
    }

    public static int getIndelSlidingWindowEditDistance(String str1, String str2, int threshold) {
        int r = LevenshteinDistance.computeLevenshteinDistanceResult(str1, str2, 1, 1, 2).getEditDistanceIndelCorrected();
        return r;
    }
}

