/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.readpairs;

import htsjdk.samtools.SAMRecord;
import org.broadinstitute.dropseqrna.junctionlibrary.JunctionSamUtils;

public class ReadPair {
    private SAMRecord read1 = null;
    private SAMRecord read2 = null;

    public ReadPair(SAMRecord read1, SAMRecord read2) {
        if (read1.getFirstOfPairFlag()) {
            this.read1 = read1;
        }
        if (read1.getSecondOfPairFlag()) {
            this.read2 = read1;
        }
        if (read2.getFirstOfPairFlag()) {
            this.read1 = read2;
        }
        if (read2.getSecondOfPairFlag()) {
            this.read2 = read2;
        }
    }

    public ReadPair getFlippedReadPair() {
        ReadPair p = new ReadPair();
        p.setRead2(this.getRead1());
        p.setRead1(this.getRead2());
        return p;
    }

    public ReadPair() {
    }

    public SAMRecord getRead1() {
        return this.read1;
    }

    public void setRead1(SAMRecord read1) {
        this.read1 = read1;
    }

    public SAMRecord getRead2() {
        return this.read2;
    }

    public void setRead2(SAMRecord read2) {
        this.read2 = read2;
    }

    public SAMRecord getFirstRead() {
        if (this.read1.getFirstOfPairFlag()) {
            return this.read1;
        }
        if (this.read2.getFirstOfPairFlag()) {
            return this.read2;
        }
        return null;
    }

    public SAMRecord getSecondRead() {
        if (this.read1.getFirstOfPairFlag()) {
            return this.read2;
        }
        if (this.read2.getFirstOfPairFlag()) {
            return this.read1;
        }
        return null;
    }

    public SAMRecord getLeftRead() {
        if (this.read1.getAlignmentStart() <= this.read2.getAlignmentStart()) {
            return this.read1;
        }
        return this.read2;
    }

    public SAMRecord getRightRead() {
        if (this.read2.getAlignmentStart() >= this.read1.getAlignmentStart()) {
            return this.read2;
        }
        return this.read1;
    }

    public boolean testProperlyPaired() {
        return JunctionSamUtils.getInstance().testPairedRead(this.read1, this.read2);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.samToString(this.read1) + "\n");
        b.append(this.samToString(this.read2) + "\n");
        return b.toString();
    }

    private String samToString(SAMRecord r) {
        StringBuilder b = new StringBuilder();
        b.append(" read name " + r.getReadName());
        b.append(" is first read " + r.getFirstOfPairFlag());
        b.append(" is unmapped " + r.getReadUnmappedFlag());
        b.append(" map quality " + r.getMappingQuality());
        b.append(" reference " + r.getReferenceName());
        b.append(" map start pos " + r.getAlignmentStart());
        b.append(" cigar " + r.getCigarString());
        b.append(" mate unmapped " + r.getMateUnmappedFlag());
        b.append(" mate reference " + r.getMateReferenceName());
        b.append(" mate start pos " + r.getMateAlignmentStart());
        return b.toString();
    }
}

