/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.math.opt;

import jdistlib.math.MultivariableFunction;
import jdistlib.math.opt.OptimizationConfig;

public class BobyqaConfig
extends OptimizationConfig {
    public static final double defaultInitialTrustRegionRadius = 0.1;
    public static final double defaultStoppingTrustRegionRadius = 1.0E-7;
    protected double initialTrustRegionRadius = 0.1;
    protected double stoppingTrustRegionRadius = 1.0E-7;
    protected int numInterpolationPoints;

    public BobyqaConfig() {
    }

    public BobyqaConfig(double[] initGuess, double[] lo, double[] hi, MultivariableFunction fun) {
        this(initGuess, lo, hi, fun, 50000, true, 0.1, 1.0E-7, initGuess.length + 6);
    }

    public BobyqaConfig(double[] initGuess, double[] lo, double[] hi, MultivariableFunction fun, int maxCall, boolean isMin) {
        this(initGuess, lo, hi, fun, maxCall, isMin, 0.1, 1.0E-7, initGuess.length + 6);
    }

    public BobyqaConfig(double[] initGuess, double[] lo, double[] hi, MultivariableFunction fun, int maxCall, boolean isMin, double initRad, double stopRad, int npt) {
        super(initGuess, lo, hi, fun, maxCall, isMin);
        this.setInitialTrustRegionRadius(initRad);
        this.setStoppingTrustRegionRadius(stopRad);
        this.setNumInterpolationPoints(npt);
    }

    public BobyqaConfig(OptimizationConfig cfg) {
        this.setInitialGuess(cfg.initialGuess);
        this.setLowerBound(cfg.lowerBound);
        this.setUpperBound(cfg.upperBound);
        this.setObjectiveFunction(cfg.objectiveFunction);
        this.setMaxNumFunctionCall(cfg.maxNumFunctionCall);
        this.setMinimize(cfg.isMinimize);
        if (cfg instanceof BobyqaConfig) {
            BobyqaConfig bcfg = (BobyqaConfig)cfg;
            this.setInitialTrustRegionRadius(bcfg.initialTrustRegionRadius);
            this.setStoppingTrustRegionRadius(bcfg.stoppingTrustRegionRadius);
            this.setNumInterpolationPoints(bcfg.numInterpolationPoints);
        } else {
            this.setInitialTrustRegionRadius(0.1);
            this.setStoppingTrustRegionRadius(1.0E-7);
            this.setNumInterpolationPoints(cfg.initialGuess.length + 6);
        }
    }

    public double getInitialTrustRegionRadius() {
        return this.initialTrustRegionRadius;
    }

    public void setInitialTrustRegionRadius(double initialTrustRegionRadius) {
        this.initialTrustRegionRadius = initialTrustRegionRadius;
    }

    public double getStoppingTrustRegionRadius() {
        return this.stoppingTrustRegionRadius;
    }

    public void setStoppingTrustRegionRadius(double stoppingTrustRegionRadius) {
        this.stoppingTrustRegionRadius = stoppingTrustRegionRadius;
    }

    public int getNumInterpolationPoints() {
        return this.numInterpolationPoints;
    }

    public void setNumInterpolationPoints(int numInterpolationPoints) {
        this.numInterpolationPoints = numInterpolationPoints;
    }
}

