/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.barnyard.digitalexpression;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.PeekableIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.dropseqrna.utils.ObjectCounter;
import org.broadinstitute.dropseqrna.utils.editdistance.MapBarcodesByEditDistance;
import picard.util.TabbedTextFileWithHeaderParser;

public class UMICollection {
    private String cellBarcode;
    private String geneName;
    private ObjectCounter<String> molecularBarcodeCounts;

    public UMICollection(String cellBarcode, String geneName) {
        this.cellBarcode = cellBarcode;
        this.geneName = geneName;
        this.molecularBarcodeCounts = new ObjectCounter();
    }

    public void incrementMolecularBarcodeCount(String molecularBarcode, int count) {
        this.molecularBarcodeCounts.incrementByCount(molecularBarcode, count);
    }

    public void incrementMolecularBarcodeCount(String molecularBarcode) {
        this.molecularBarcodeCounts.incrementByCount(molecularBarcode, 1);
    }

    public String getCellBarcode() {
        return this.cellBarcode;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public ObjectCounter<String> getMolecularBarcodeCounts() {
        return this.molecularBarcodeCounts;
    }

    public Collection<String> getMolecularBarcodes() {
        return this.molecularBarcodeCounts.getKeys();
    }

    public boolean isEmpty() {
        return this.molecularBarcodeCounts.getSize() == 0;
    }

    public ObjectCounter<String> getMolecularBarcodeCountsCollapsed(int editDistance) {
        ObjectCounter<String> counts = this.collapseByEditDistance(this.molecularBarcodeCounts, editDistance);
        return counts;
    }

    public void filterByUMIFrequency(double freq) {
        boolean total = false;
        double average = this.molecularBarcodeCounts.getTotalCount() / this.molecularBarcodeCounts.getSize();
        int minNumReads = (int)Math.floor(average * freq);
        this.molecularBarcodeCounts.filterByMinCount(minNumReads);
    }

    public int getDigitalExpression(int minBCReadThreshold, int editDistance, boolean outputReads) {
        if (outputReads) {
            int count = this.molecularBarcodeCounts.getTotalCount();
            return count;
        }
        ObjectCounter<String> counts = this.collapseByEditDistance(this.molecularBarcodeCounts, editDistance);
        counts.filterByMinCount(minBCReadThreshold);
        int count = counts.getKeys().size();
        return count;
    }

    private ObjectCounter<String> collapseByEditDistance(ObjectCounter<String> counts, int editDistance) {
        ObjectCounter<String> result = new ObjectCounter<String>();
        MapBarcodesByEditDistance mbed = new MapBarcodesByEditDistance(false, 0);
        Map<String, List<String>> collapseMap = mbed.collapseBarcodes(counts, false, editDistance);
        for (String key : collapseMap.keySet()) {
            int totalCount = this.molecularBarcodeCounts.getCountForKey(key);
            List<String> values = collapseMap.get(key);
            for (String bc : values) {
                int count = this.molecularBarcodeCounts.getCountForKey(bc);
                totalCount += count;
            }
            result.setCount(key, totalCount);
        }
        return result;
    }

    public static Collection<UMICollection> parseUMICollectionFile(File input) {
        String gene;
        String cell;
        TabbedTextFileWithHeaderParser.Row row;
        IOUtil.assertFileIsReadable((File)input);
        ArrayList<UMICollection> result = new ArrayList<UMICollection>();
        TabbedTextFileWithHeaderParser parser = new TabbedTextFileWithHeaderParser(input);
        UMICollection currentUMI = null;
        PeekableIterator parserIter = new PeekableIterator((Iterator)parser.iterator());
        if (parserIter.hasNext()) {
            row = (TabbedTextFileWithHeaderParser.Row)parserIter.peek();
            cell = row.getField("Cell Barcode");
            gene = row.getField("Gene");
            currentUMI = new UMICollection(cell, gene);
        }
        while (parserIter.hasNext()) {
            row = (TabbedTextFileWithHeaderParser.Row)parserIter.next();
            cell = row.getField("Cell Barcode");
            gene = row.getField("Gene");
            String molBC = row.getField("Molecular_Barcode");
            int count = Integer.parseInt(row.getField("Num_Obs"));
            if (!cell.equals(currentUMI.cellBarcode) || !gene.equals(currentUMI.geneName)) {
                result.add(currentUMI);
                currentUMI = new UMICollection(cell, gene);
            }
            currentUMI.incrementMolecularBarcodeCount(molBC, count);
        }
        if (currentUMI.molecularBarcodeCounts.getSize() > 0) {
            result.add(currentUMI);
        }
        CloserUtil.close((Object)parserIter);
        return result;
    }

    public String toString() {
        return "[" + this.cellBarcode + "] + [" + this.geneName + "] " + this.molecularBarcodeCounts.toString();
    }
}

