/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import htsjdk.samtools.util.IterableOnceIterator;
import htsjdk.samtools.util.PeekableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class GroupingIterator<T>
extends IterableOnceIterator<List<T>> {
    private final PeekableIterator<T> underlyingIterator;
    private final Comparator<T> comparator;

    public GroupingIterator(Iterator<T> underlyingIterator, Comparator<T> comparator) {
        this.underlyingIterator = new PeekableIterator(underlyingIterator);
        this.comparator = comparator;
    }

    public boolean hasNext() {
        return this.underlyingIterator.hasNext();
    }

    public List<T> next() {
        ArrayList<Object> ret = new ArrayList<Object>(1);
        Object last = this.underlyingIterator.next();
        ret.add(last);
        while (this.underlyingIterator.hasNext()) {
            int cmp = this.comparator.compare(last, this.underlyingIterator.peek());
            if (cmp == 0) {
                last = this.underlyingIterator.next();
                ret.add(last);
                continue;
            }
            if (cmp < 0) {
                return ret;
            }
            throw new IllegalStateException(String.format("Out of order iterator: %s > %s", last.toString(), this.underlyingIterator.peek().toString()));
        }
        return ret;
    }

    public void close() throws IOException {
        this.underlyingIterator.close();
        super.close();
    }
}

