/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.readiterators;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.dropseqrna.utils.FilteredIterator;
import org.broadinstitute.dropseqrna.utils.GroupingIterator;
import org.broadinstitute.dropseqrna.utils.MultiComparator;
import org.broadinstitute.dropseqrna.utils.StringTagComparator;
import org.broadinstitute.dropseqrna.utils.readiterators.GeneStrandFilteringIterator;
import org.broadinstitute.dropseqrna.utils.readiterators.MapQualityFilteredIterator;
import org.broadinstitute.dropseqrna.utils.readiterators.MissingTagFilteringIterator;
import org.broadinstitute.dropseqrna.utils.readiterators.SamHeaderAndIterator;
import org.broadinstitute.dropseqrna.utils.readiterators.SamRecordSortingIteratorFactory;

public class UMIReadIterator
implements CloseableIterator<List<SAMRecord>> {
    private static final Log log = Log.getInstance(UMIReadIterator.class);
    private static final ProgressLogger prog = new ProgressLogger(log);
    private final GroupingIterator<SAMRecord> atoi;

    public UMIReadIterator(SamHeaderAndIterator headerAndIterator, String geneExonTag, String cellBarcodeTag, String molecularBarcodeTag, String strandTag, boolean useStrandInfo, int readMQ, boolean rejectNonPrimaryReads, List<String> cellBarcodes) {
        StringTagComparator cellBarcodeTagComparator = new StringTagComparator(cellBarcodeTag);
        StringTagComparator geneExonTagComparator = new StringTagComparator(geneExonTag);
        StringTagComparator molecularBarcodeTagComparator = new StringTagComparator(molecularBarcodeTag);
        MultiComparator<SAMRecord> multiComparator = new MultiComparator<SAMRecord>(cellBarcodeTagComparator, geneExonTagComparator, molecularBarcodeTagComparator);
        FilteredIterator filteringIterator = new MissingTagFilteringIterator((Iterator<SAMRecord>)headerAndIterator.iterator, cellBarcodeTag, geneExonTag, molecularBarcodeTag, strandTag);
        filteringIterator = new MapQualityFilteredIterator((Iterator<SAMRecord>)((Object)filteringIterator), readMQ, rejectNonPrimaryReads);
        if (useStrandInfo) {
            filteringIterator = new GeneStrandFilteringIterator((Iterator<SAMRecord>)((Object)filteringIterator), strandTag);
        }
        CloseableIterator<SAMRecord> sortedAlignmentIterator = SamRecordSortingIteratorFactory.create(headerAndIterator.header, (Iterator<SAMRecord>)((Object)filteringIterator), multiComparator, prog);
        this.atoi = new GroupingIterator<SAMRecord>((Iterator<SAMRecord>)sortedAlignmentIterator, (Comparator<SAMRecord>)multiComparator);
    }

    public List<SAMRecord> next() {
        if (!this.atoi.hasNext()) {
            return null;
        }
        return this.atoi.next();
    }

    public boolean hasNext() {
        return this.atoi.hasNext();
    }

    public void close() {
        CloserUtil.close(this.atoi);
    }
}

