/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.annotation;

import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IterableOnceIterator;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.broadinstitute.dropseqrna.annotation.AnnotationUtils;
import org.broadinstitute.dropseqrna.annotation.GTFRecord;
import picard.annotation.AnnotationException;
import picard.util.TabbedTextFileWithHeaderParser;

public class GTFParser
extends IterableOnceIterator<GTFRecord> {
    private static final Log LOG = Log.getInstance(GTFParser.class);
    private static final String[] GTFColumnLabels = new String[GTFFlatColumns.values().length];
    private final File gtfFile;
    private final CloseableIterator<TabbedTextFileWithHeaderParser.Row> it;
    private final ProgressLogger progressLogger;
    private final ValidationStringency validationStringency;

    public GTFParser(File gtfFile, ValidationStringency validationStringency) {
        this.gtfFile = gtfFile;
        this.it = new TabbedTextFileWithHeaderParser(gtfFile, GTFColumnLabels).iterator();
        this.progressLogger = new ProgressLogger(LOG, 100000, "read", "GTF records");
        this.validationStringency = validationStringency;
    }

    public void close() {
        this.it.close();
    }

    public boolean hasNext() {
        return this.it.hasNext();
    }

    public GTFRecord next() {
        List<String> errors;
        TabbedTextFileWithHeaderParser.Row row = (TabbedTextFileWithHeaderParser.Row)this.it.next();
        if (row.getFields().length != GTFColumnLabels.length) {
            throw new AnnotationException("Wrong number of fields in GTF file " + this.gtfFile + " at line " + row.getCurrentLine());
        }
        GTFRecord ret = this.parseLine(row);
        if (this.validationStringency != ValidationStringency.SILENT && (errors = ret.validate()) != null && !errors.isEmpty()) {
            String message = String.format("Invalid GTF line: \n%s\nProblems:\n%s", row.getCurrentLine(), CollectionUtil.join(errors, (String)"\n"));
            if (this.validationStringency == ValidationStringency.STRICT) {
                throw new AnnotationException(message);
            }
            LOG.warn(new Object[]{message});
        }
        this.progressLogger.record(ret.getChromosome(), ret.getStart());
        return ret;
    }

    public void remove() {
        this.it.remove();
    }

    private GTFRecord parseLine(TabbedTextFileWithHeaderParser.Row row) {
        String attributes = row.getField(GTFFlatColumns.ATTRIBUTE.name());
        Map<String, String> attributesMap = AnnotationUtils.getInstance().parseOptionalFields(attributes);
        String chromosome = row.getField(GTFFlatColumns.CHROMOSOME.name());
        int start = Integer.parseInt(row.getField(GTFFlatColumns.START.name()));
        int end = Integer.parseInt(row.getField(GTFFlatColumns.END.name()));
        String strand = row.getField(GTFFlatColumns.STRAND.name());
        String featureType = row.getField(GTFFlatColumns.FEATURE.name());
        String geneName = attributesMap.get("gene_name");
        String geneID = attributesMap.get("gene_id");
        String transcriptName = attributesMap.get("transcript_name");
        String transcriptID = attributesMap.get("transcript_id");
        String transcriptType = attributesMap.get("gene_biotype");
        String geneVersionString = attributesMap.get("gene_version");
        Integer geneVersion = geneVersionString != null ? new Integer(geneVersionString) : null;
        boolean negativeStrand = strand.equals("-");
        return new GTFRecord(chromosome, start, end, negativeStrand, geneID, geneName, transcriptName, transcriptID, transcriptType, featureType, geneVersion);
    }

    static {
        for (int i = 0; i < GTFColumnLabels.length; ++i) {
            GTFParser.GTFColumnLabels[i] = GTFFlatColumns.values()[i].name();
        }
    }

    public static enum GTFFeature {
        CDS,
        UTR,
        exon,
        gene,
        start_codon,
        stop_codon,
        transcript;

    }

    public static enum GTFFlatColumns {
        CHROMOSOME,
        SOURCE,
        FEATURE,
        START,
        END,
        SCORE,
        STRAND,
        FRAME,
        ATTRIBUTE;

    }
}

