/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.annotation;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.OverlapDetector;
import java.io.File;
import org.broadinstitute.dropseqrna.annotation.GTFReader;
import org.broadinstitute.dropseqrna.annotation.GeneFromGTF;
import picard.annotation.Gene;

public class GeneAnnotationReader {
    public static OverlapDetector<Gene> loadAnnotationsFile(File annotationFile, SAMSequenceDictionary sequenceDictionary) {
        String f = annotationFile.getName();
        if (f.endsWith(".bz2")) {
            f = f.replaceAll("\\.bz2", "");
        }
        if (f.endsWith(".gz")) {
            f = f.replaceAll("\\.gz", "");
        }
        if (f.endsWith(".gtf")) {
            return GeneAnnotationReader.loadGTFFile(annotationFile, sequenceDictionary);
        }
        if (f.endsWith(".refFlat")) {
            return GeneAnnotationReader.loadRefFlat(annotationFile, sequenceDictionary);
        }
        throw new SAMException("Unable to determine file format for gene annotation file.  Expect [.gtf | .refFlat]");
    }

    public static OverlapDetector<Gene> loadAnnotationsFile(File annotationFile, File sequenceDictionary) {
        SAMSequenceDictionary sd = GeneAnnotationReader.getSequenceDictionary(sequenceDictionary);
        return GeneAnnotationReader.loadAnnotationsFile(annotationFile, sd);
    }

    private static OverlapDetector<Gene> loadGTFFile(File gtfFile, SAMSequenceDictionary sequenceDictionary) {
        OverlapDetector<GeneFromGTF> result = GTFReader.load(gtfFile, sequenceDictionary);
        return result;
    }

    private static OverlapDetector<Gene> loadRefFlat(File refFlatFile, SAMSequenceDictionary sequenceDictionary) {
        return picard.annotation.GeneAnnotationReader.loadRefFlat((File)refFlatFile, (SAMSequenceDictionary)sequenceDictionary);
    }

    private static SAMSequenceDictionary getSequenceDictionary(File sd) {
        SamReader reader = SamReaderFactory.makeDefault().open(sd);
        SAMSequenceDictionary dict = reader.getFileHeader().getSequenceDictionary();
        CloserUtil.close((Object)reader);
        return dict;
    }
}

