/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.annotation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.broadinstitute.dropseqrna.annotation.AnnotationUtils;

public class RefFlatRecord {
    private String geneName;
    private String transcriptName;
    private String chromosome;
    private boolean isNegativeStrand;
    private int transcriptStart;
    private int transcriptEnd;
    private int cdsStart;
    private int cdsEnd;
    List<Integer> exonStarts;
    List<Integer> exonEnds;

    public RefFlatRecord(String geneName, String transcriptName, String chromosome, boolean isNegativeStrand, int transcriptStart, int transcriptEnd, int cdsStart, int cdsEnd) {
        this.geneName = geneName;
        this.transcriptName = transcriptName;
        this.chromosome = chromosome;
        this.isNegativeStrand = isNegativeStrand;
        this.transcriptStart = transcriptStart - 1;
        this.transcriptEnd = transcriptEnd;
        this.cdsStart = cdsStart - 1;
        this.cdsEnd = cdsEnd;
        this.exonStarts = new ArrayList<Integer>();
        this.exonEnds = new ArrayList<Integer>();
    }

    public String getGeneName() {
        return this.geneName;
    }

    public void setGeneName(String geneName) {
        this.geneName = geneName;
    }

    public String getTranscriptName() {
        return this.transcriptName;
    }

    public String getChromosome() {
        return this.chromosome;
    }

    public boolean isNegativeStrand() {
        return this.isNegativeStrand;
    }

    public int getTranscriptStart() {
        return this.transcriptStart;
    }

    public int getTranscriptEnd() {
        return this.transcriptEnd;
    }

    public int getCdsStart() {
        return this.cdsStart;
    }

    public int getCdsEnd() {
        return this.cdsEnd;
    }

    public List<Integer> getExonStarts() {
        return this.exonStarts;
    }

    public List<Integer> getExonEnds() {
        return this.exonEnds;
    }

    public void addExonStart(int start) {
        this.exonStarts.add(start - 1);
    }

    public void addExonEnd(int end) {
        this.exonEnds.add(end);
    }

    public String getFormattedExonString(List<Integer> positions) {
        StringBuilder b = new StringBuilder();
        for (Integer i : positions) {
            b.append(i.toString());
            b.append(",");
        }
        return b.toString();
    }

    public String toString() {
        ArrayList<String> r = new ArrayList<String>(11);
        r.add(this.geneName);
        r.add(this.transcriptName);
        r.add(this.chromosome);
        r.add(AnnotationUtils.strandToString(!this.isNegativeStrand));
        r.add(Integer.toString(this.transcriptStart));
        r.add(Integer.toString(this.transcriptEnd));
        r.add(Integer.toString(this.cdsStart));
        r.add(Integer.toString(this.cdsEnd));
        r.add(Integer.toString(this.getExonStarts().size()));
        r.add(this.getFormattedExonString(this.exonStarts));
        r.add(this.getFormattedExonString(this.exonEnds));
        String h = StringUtils.join(r, (String)"\t");
        return h;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefFlatRecord that = (RefFlatRecord)o;
        if (!this.geneName.equals(that.geneName)) {
            return false;
        }
        if (!this.transcriptName.equals(that.transcriptName)) {
            return false;
        }
        if (!this.chromosome.equals(that.chromosome)) {
            return false;
        }
        if (this.transcriptStart != that.transcriptStart) {
            return false;
        }
        if (this.transcriptEnd != that.transcriptEnd) {
            return false;
        }
        if (this.cdsStart != that.cdsStart) {
            return false;
        }
        if (this.cdsEnd != that.cdsEnd) {
            return false;
        }
        if (!this.getFormattedExonString(this.exonStarts).equals(this.getFormattedExonString(that.exonStarts))) {
            return false;
        }
        return this.getFormattedExonString(this.exonEnds).equals(this.getFormattedExonString(that.exonEnds));
    }
}

