/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.beadsynthesis;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.math.NumberUtils;
import org.broadinstitute.dropseqrna.beadsynthesis.BeadSynthesisErrorTypes;
import org.broadinstitute.dropseqrna.utils.BaseDistributionMetric;
import org.broadinstitute.dropseqrna.utils.BaseDistributionMetricCollection;
import org.broadinstitute.dropseqrna.utils.Bases;
import org.broadinstitute.dropseqrna.utils.ObjectCounter;

public class BeadSynthesisErrorData {
    private final String cellBarcode;
    private BaseDistributionMetricCollection baseCounts;
    private ObjectCounter<String> umiCounts;
    private int numReads;
    private int numTranscripts;
    private boolean dataChanged;
    private BeadSynthesisErrorTypes errorTypeCached = null;

    public BeadSynthesisErrorData(String cellBarcode) {
        this.cellBarcode = cellBarcode;
        this.baseCounts = new BaseDistributionMetricCollection();
        this.umiCounts = new ObjectCounter();
        this.dataChanged = true;
        this.numReads = 0;
        this.numTranscripts = 0;
    }

    public void addUMI(String umi) {
        this.umiCounts.increment(umi);
        this.baseCounts.addBases(umi);
        this.dataChanged = true;
    }

    public void addUMI(Collection<String> umis) {
        for (String umi : umis) {
            this.addUMI(umi);
        }
    }

    public void incrementReads(int numReads) {
        this.numReads += numReads;
    }

    public void incrementTranscripts(int numTranscripts) {
        this.numTranscripts += numTranscripts;
    }

    public int getNumReads() {
        return this.numReads;
    }

    public int getNumTranscripts() {
        return this.numTranscripts;
    }

    public int getUMICount() {
        return this.umiCounts.getTotalCount();
    }

    public ObjectCounter<String> getUMICounts() {
        return this.umiCounts;
    }

    public String getCellBarcode() {
        return this.cellBarcode;
    }

    public BaseDistributionMetricCollection getBaseCounts() {
        return this.baseCounts;
    }

    public int getBaseLength() {
        return this.baseCounts.getPositions().size();
    }

    public BeadSynthesisErrorTypes getErrorType(double threshold) {
        BeadSynthesisErrorTypes t;
        int polyTPos;
        if (!this.dataChanged & this.errorTypeCached != null) {
            return this.errorTypeCached;
        }
        this.dataChanged = false;
        int errorPosition = this.getErrorBase(threshold);
        if (errorPosition == (polyTPos = this.getPolyTErrorPosition(threshold)) & errorPosition != -1) {
            BeadSynthesisErrorTypes t2;
            this.errorTypeCached = t2 = BeadSynthesisErrorTypes.SYNTH_MISSING_BASE;
            return t2;
        }
        if (this.hasSingleUMIError(threshold)) {
            BeadSynthesisErrorTypes t3;
            this.errorTypeCached = t3 = BeadSynthesisErrorTypes.SINGLE_UMI;
            return t3;
        }
        if (this.hasFixedFirstBase(threshold)) {
            BeadSynthesisErrorTypes t4;
            this.errorTypeCached = t4 = BeadSynthesisErrorTypes.FIXED_FIRST_BASE;
            return t4;
        }
        if (errorPosition != polyTPos) {
            BeadSynthesisErrorTypes t5;
            this.errorTypeCached = t5 = BeadSynthesisErrorTypes.OTHER_ERROR;
            return t5;
        }
        this.errorTypeCached = t = BeadSynthesisErrorTypes.NO_ERROR;
        return t;
    }

    public int getPolyTErrorPosition(double threshold) {
        double v;
        double[] freq = this.getPolyTFrequency();
        int errorBase = -2;
        int position = freq.length - 1;
        while (position >= 0 && (v = freq[position]) >= threshold) {
            errorBase = position--;
        }
        return errorBase + 1;
    }

    public boolean hasSingleUMIError(double threshold) {
        double[] data;
        for (double d : data = this.synthesisErrorMetric()) {
            if (!(d < threshold)) continue;
            return false;
        }
        return true;
    }

    public boolean hasFixedFirstBase(double threshold) {
        double[] data = this.synthesisErrorMetric();
        boolean pos0Fixed = data[0] >= threshold;
        boolean otherPositionsNotFixed = true;
        for (int i = 1; i < data.length; ++i) {
            if (!(data[i] > threshold)) continue;
            otherPositionsNotFixed = false;
            break;
        }
        boolean fixedFirstBase = pos0Fixed & otherPositionsNotFixed;
        return fixedFirstBase;
    }

    public double[] getPolyTFrequency() {
        this.dataChanged = false;
        char base = Bases.T.getBase().charValue();
        List<Integer> basePositions = this.baseCounts.getPositions();
        double[] result = new double[basePositions.size()];
        for (int position = 0; position < result.length; ++position) {
            double freq;
            BaseDistributionMetric bdm = this.baseCounts.getDistributionAtPosition(position);
            result[position] = freq = (double)bdm.getCount(Character.valueOf(base)) / (double)bdm.getTotalCount();
        }
        return result;
    }

    public boolean hasSynthesisError(double threshold) {
        double[] m = this.synthesisErrorMetric();
        double max = NumberUtils.max((double[])m);
        return max >= threshold;
    }

    public int getErrorBase(double threshold) {
        double[] m = this.synthesisErrorMetric();
        for (int i = 0; i < m.length; ++i) {
            if (!(m[i] >= threshold)) continue;
            return i + 1;
        }
        return -1;
    }

    public double[] synthesisErrorMetric() {
        this.dataChanged = false;
        List<Integer> basePositions = this.baseCounts.getPositions();
        double[] result = new double[basePositions.size()];
        for (int i : basePositions) {
            result[i] = this.getMostCommonBaseFrequency(i);
        }
        return result;
    }

    private double getMostCommonBaseFrequency(int position) {
        BaseDistributionMetric bdm = this.baseCounts.getDistributionAtPosition(position);
        double totalCount = bdm.getTotalCount();
        double maxFreq = 0.0;
        for (Bases b : Bases.values()) {
            char bb = b.getBase().charValue();
            int count = bdm.getCount(Character.valueOf(bb));
            double freq = (double)count / totalCount;
            if (!(freq > maxFreq)) continue;
            maxFreq = freq;
        }
        return maxFreq;
    }
}

