/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.beadsynthesis;

import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.dropseqrna.beadsynthesis.AbstractDetectBeadSynthesisErrors;
import org.broadinstitute.dropseqrna.beadsynthesis.BarcodeNeighborGroup;
import org.broadinstitute.dropseqrna.beadsynthesis.BeadSynthesisErrorData;
import org.broadinstitute.dropseqrna.beadsynthesis.BiasedBarcodeCollection;
import org.broadinstitute.dropseqrna.cmdline.DropSeq;
import org.broadinstitute.dropseqrna.utils.readiterators.UMIIterator;
import picard.cmdline.CommandLineProgramProperties;

@CommandLineProgramProperties(usage="For each cell, gather up all the UMIs.  An error in synthesis will result in the last base of the synthesis being fixed in >80% of the UMIs for that cell, across all genes.This fixed base is T.  Cluster together sets of cell barcodes with UMI bias that are edit distance 1 apart, where the error occurs at the last base.  Search for cell barcodesequences that at ED=1 (using an indel, not a substitution) from one cell barcode sequence to the new cluster of sequences.  If found, this is the intended sequence that explainsthis cluster of errors.  If not found, the synthesis error is complete or is a deletion at base 12.  For cell barcodes where this occurs, output the cell barcode in a file, as well as (optionally) pad the cell barcodes with N for the error bases.", usageShort="Detect barcode synthesis errors where the final base of a UMI is fixed across all UMIs of a cell.", programGroup=DropSeq.class)
public class DetectIncompleteBeadSynthesisErrors
extends AbstractDetectBeadSynthesisErrors {
    private static final Log log = Log.getInstance(DetectIncompleteBeadSynthesisErrors.class);
    private double UMIBiasThreshold = 0.6;

    protected int doWork() {
        UMIIterator iterator = this.prepareUMIIterator();
        BiasedBarcodeCollection biasedBarcodeCollection = this.findBiasedBarcodes(iterator);
        Map<String, BeadSynthesisErrorData> errorBarcodesWithPositions = biasedBarcodeCollection.getBiasedBarcodes();
        int numCellsFilteredLowUMIs = biasedBarcodeCollection.getNumBarcodesFilteredLowUMIs();
        List<BarcodeNeighborGroup> neighborGroups = this.buildBarcodeNeighborGroups(errorBarcodesWithPositions, this.UMIBiasThreshold);
        return 0;
    }

    private List<BarcodeNeighborGroup> buildBarcodeNeighborGroups(Map<String, BeadSynthesisErrorData> errorBarcodesWithPositions, double umiBiasThreshold) {
        HashMap<String, BarcodeNeighborGroup> result = new HashMap<String, BarcodeNeighborGroup>();
        for (String k : errorBarcodesWithPositions.keySet()) {
            BeadSynthesisErrorData b = errorBarcodesWithPositions.get(k);
            int polyTErrorPosition = b.getPolyTErrorPosition(umiBiasThreshold);
            if (polyTErrorPosition == -1) continue;
            int umiLength = b.getBaseLength();
            int numErrors = umiLength - polyTErrorPosition + 1;
            String cellBCRoot = this.padCellBarcode(b.getCellBarcode(), polyTErrorPosition, umiLength);
            BarcodeNeighborGroup bng = (BarcodeNeighborGroup)result.get(cellBCRoot);
            if (bng == null) {
                bng = new BarcodeNeighborGroup();
            }
            bng.addNeighbor(b);
            result.put(cellBCRoot, bng);
        }
        return new ArrayList<BarcodeNeighborGroup>(result.values());
    }

    public static void main(String[] args) {
        System.exit(new DetectIncompleteBeadSynthesisErrors().instanceMain(args));
    }
}

