/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.beadsynthesis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.dropseqrna.utils.editdistance.EDUtils;

public class DetectPrimerInUMI {
    private final String primer;
    private Map<Integer, List<String>> primerSubstrings;

    public DetectPrimerInUMI(String primer) {
        this.primer = primer;
        this.primerSubstrings = new HashMap<Integer, List<String>>();
    }

    public boolean isStringInPrimer(String str, int editDistance) {
        List<String> primerSubstrings = this.getSubstrings(str.length());
        Set<String> matchingPrimerSubstrings = EDUtils.getInstance().getStringsWithinHammingDistance(str, primerSubstrings, editDistance);
        return !matchingPrimerSubstrings.isEmpty();
    }

    public List<String> getSubstrings(int length) {
        if (this.primerSubstrings.containsKey(length)) {
            return this.primerSubstrings.get(length);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int startPos = 0; startPos < this.primer.length() - length + 1; ++startPos) {
            String r = this.primer.substring(startPos, startPos + length);
            result.add(r);
        }
        this.primerSubstrings.put(length, result);
        return result;
    }
}

