/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.metrics;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.broadinstitute.dropseqrna.cmdline.DropSeq;
import org.broadinstitute.dropseqrna.metrics.TagOfTagResults;
import org.broadinstitute.dropseqrna.utils.CustomBAMIterators;
import org.broadinstitute.dropseqrna.utils.StringTagComparator;
import org.broadinstitute.dropseqrna.utils.io.ErrorCheckingPrintStream;
import org.broadinstitute.dropseqrna.utils.readiterators.SamRecordSortingIteratorFactory;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;

@CommandLineProgramProperties(usage="For a given BAM tag, how many unique values of a second BAM tag are present?", usageShort="For a given BAM tag, how many unique values of a second BAM tag are present?", programGroup=DropSeq.class)
public class BAMTagofTagCounts
extends CommandLineProgram {
    private static final Log log = Log.getInstance(BAMTagofTagCounts.class);
    @Option(shortName="I", doc="The input SAM or BAM file to analyze.  Must be coordinate sorted. (???)")
    public File INPUT;
    @Option(shortName="O", doc="Output file of tag frequencies. This supports zipped formats like gz and bz2.")
    public File OUTPUT;
    @Option(doc="Primary Tag to extract")
    public String PRIMARY_TAG;
    @Option(doc="Secondary Tag to extract")
    public String SECONDARY_TAG;
    @Option(doc="Remove Singleton Results")
    public Boolean REMOVE_SINGLETONS = false;
    @Option(doc="Filter PCR Duplicates.  Defaults to true")
    public boolean FILTER_PCR_DUPLICATES = true;
    @Option(doc="Read quality filter.  Filters all reads lower than this mapping quality.  Defaults to 10.  Set to 0 to not filter reads by map quality.")
    public Integer READ_QUALITY = 10;
    @Option(doc="If the secondary tag can occur multiple times, break it up with this delimiter.", optional=true)
    public String SECONDARY_DELIMITER;
    public static final int MAX_RECORDS_IN_RAM = 500000;

    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        ErrorCheckingPrintStream out = new ErrorCheckingPrintStream(IOUtil.openFileForWriting((File)this.OUTPUT));
        this.writeHeader(out);
        TagOfTagResults<String, String> results = this.getResults(this.INPUT, this.PRIMARY_TAG, this.SECONDARY_TAG, this.FILTER_PCR_DUPLICATES, this.READ_QUALITY);
        for (String k : results.getKeys()) {
            Set<String> values = results.getValues(k);
            this.writeStats(k, values, out);
        }
        ((PrintStream)out).close();
        return 0;
    }

    public TagOfTagResults<String, String> getResults(File inputBAM, String primaryTag, String secondaryTag, boolean filterPCRDuplicates, Integer readQuality) {
        TagOfTagResults<String, String> result = new TagOfTagResults<String, String>();
        SamReader reader = SamReaderFactory.makeDefault().open(inputBAM);
        CloseableIterator<SAMRecord> iter = CustomBAMIterators.getReadsInTagOrder(reader, primaryTag);
        CloserUtil.close((Object)reader);
        String currentTag = "";
        Set<String> otherTagCollection = new HashSet<String>();
        ProgressLogger progress = new ProgressLogger(log);
        while (iter.hasNext()) {
            Object d;
            SAMRecord r = (SAMRecord)iter.next();
            progress.record(r);
            boolean discardResult = filterPCRDuplicates && r.getDuplicateReadFlag() || r.getMappingQuality() < readQuality || r.isSecondaryOrSupplementary();
            if (discardResult || (d = r.getAttribute(secondaryTag)) == null) continue;
            String data = null;
            if (d instanceof String) {
                data = r.getStringAttribute(secondaryTag);
            } else if (d instanceof Integer) {
                data = Integer.toString(r.getIntegerAttribute(secondaryTag));
            }
            String newTag = r.getStringAttribute(primaryTag);
            if (newTag == null) {
                newTag = "";
            }
            if (!currentTag.equals(newTag)) {
                if (!currentTag.equals("") && otherTagCollection.size() > 0) {
                    result.addEntries(currentTag, otherTagCollection);
                }
                currentTag = newTag;
                otherTagCollection.clear();
                if (discardResult) continue;
                otherTagCollection = this.addTagToCollection(data, otherTagCollection);
                continue;
            }
            if (discardResult) continue;
            otherTagCollection = this.addTagToCollection(data, otherTagCollection);
        }
        if (otherTagCollection.size() > 0) {
            result.addEntries(currentTag, otherTagCollection);
        }
        return result;
    }

    private Set<String> addTagToCollection(String data, Set<String> collection) {
        if (this.SECONDARY_DELIMITER != null) {
            String[] d2 = data.split(this.SECONDARY_DELIMITER);
            Collections.addAll(collection, d2);
        } else {
            collection.add(data);
        }
        return collection;
    }

    private void writeStats(String tag, Set<String> otherTagCollection, PrintStream out) {
        if (!this.REMOVE_SINGLETONS.booleanValue() || otherTagCollection.size() > 1) {
            String otherTagList = StringUtils.join(otherTagCollection, (String)":");
            Object[] line = new String[]{tag, otherTagCollection.size() + "", otherTagList};
            String h = StringUtils.join((Object[])line, (String)"\t");
            out.println(h);
        }
    }

    private void writeHeader(PrintStream out) {
        Object[] header = new String[]{"TAG", "COUNT", "TAG_LIST"};
        String h = StringUtils.join((Object[])header, (String)"\t");
        out.println(h);
    }

    public CloseableIterator<SAMRecord> getReadsInTagOrder(File bamFile) {
        SamReader reader = SamReaderFactory.makeDefault().open(this.INPUT);
        SAMSequenceDictionary dict = reader.getFileHeader().getSequenceDictionary();
        List programs = reader.getFileHeader().getProgramRecords();
        SAMFileHeader writerHeader = new SAMFileHeader();
        writerHeader.setSortOrder(SAMFileHeader.SortOrder.queryname);
        writerHeader.setSequenceDictionary(dict);
        for (SAMProgramRecord spr : programs) {
            writerHeader.addProgramRecord(spr);
        }
        log.info(new Object[]{"Reading in records for TAG name sorting"});
        ProgressLogger progressLogger = new ProgressLogger(log, 1000000);
        CloseableIterator<SAMRecord> result = SamRecordSortingIteratorFactory.create(writerHeader, (Iterator<SAMRecord>)reader.iterator(), new StringTagComparator(this.PRIMARY_TAG), progressLogger);
        log.info(new Object[]{"Sorting finished."});
        return result;
    }

    public static void main(String[] args) {
        System.exit(new BAMTagofTagCounts().instanceMain(args));
    }
}

