/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.metrics;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TagOfTagResults<KEY, VALUE> {
    private Map<KEY, Set<VALUE>> result = new HashMap<KEY, Set<VALUE>>();
    private Map<VALUE, VALUE> valueCache = new HashMap<VALUE, VALUE>();

    public Set<KEY> getKeys() {
        return this.result.keySet();
    }

    public Set<VALUE> getValues(String key) {
        return this.result.get(key);
    }

    public Integer getCount(String key) {
        return this.result.get(key).size();
    }

    public void addEntry(KEY key, VALUE value) {
        Set<VALUE> values = this.result.get(key);
        if (values == null) {
            values = new HashSet<VALUE>();
            this.result.put(key, values);
        }
        VALUE v = this.checkCache(value);
        values.add(v);
    }

    public void addEntries(KEY key, Collection<VALUE> value) {
        for (VALUE v : value) {
            this.addEntry(key, v);
        }
    }

    private VALUE checkCache(VALUE key) {
        VALUE v = this.valueCache.get(key);
        if (v != null) {
            return v;
        }
        this.valueCache.put(key, key);
        return this.checkCache(key);
    }
}

