/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.readtrimming;

import htsjdk.samtools.SAMRecord;
import org.broadinstitute.dropseqrna.readtrimming.PolyAFinder;

public class SimplePolyAFinder
implements PolyAFinder {
    private int minNumBases;
    private int numMismatchBases;

    public SimplePolyAFinder(int minNumBases, int numMismatchBases) {
        this.minNumBases = minNumBases;
        this.numMismatchBases = numMismatchBases;
    }

    @Override
    public PolyAFinder.PolyARun getPolyAStart(SAMRecord rec) {
        return this.getPolyAStart(rec.getReadString());
    }

    public PolyAFinder.PolyARun getPolyAStart(String readString) {
        char[] seq = readString.toUpperCase().toCharArray();
        boolean inRun = false;
        int numInRun = 0;
        int numError = 0;
        int runStartPos = -1;
        int bestRunStart = -1;
        int bestNumInRun = -1;
        int bestRunLength = -1;
        int nextRunStartPos = -1;
        for (int i = 0; i < seq.length; ++i) {
            char s = seq[i];
            if (s == 'A' && inRun) {
                ++numInRun;
                if (seq[i - 1] != 'A' && nextRunStartPos == -1) {
                    nextRunStartPos = i;
                }
            }
            if (s == 'A' & !inRun) {
                ++numInRun;
                inRun = true;
                runStartPos = i;
            }
            if (s != 'A' & inRun) {
                ++numInRun;
                if (++numError > this.numMismatchBases) {
                    if (numInRun - numError > bestNumInRun) {
                        bestRunStart = runStartPos;
                        bestNumInRun = numInRun - numError;
                        bestRunLength = i - runStartPos;
                    }
                    runStartPos = -1;
                    numInRun = 0;
                    numError = 0;
                    inRun = false;
                    if (nextRunStartPos != -1) {
                        i = nextRunStartPos - 1;
                        nextRunStartPos = -1;
                    }
                }
            }
            if (!(s != 'A' & !inRun)) continue;
        }
        if (inRun && numInRun - numError > bestNumInRun) {
            bestRunStart = runStartPos;
            bestNumInRun = numInRun - numError;
            bestRunLength = seq.length - runStartPos;
        }
        if (bestNumInRun >= this.minNumBases) {
            return new PolyAFinder.PolyARun(bestRunStart, bestRunLength);
        }
        return PolyAFinder.PolyARun.NO_MATCH_RUN;
    }
}

