/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.readtrimming;

import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.broadinstitute.dropseqrna.TranscriptomeException;

public class TrimSequenceTemplate {
    private final String sequence;
    private final String reverseComplement;
    private final byte[] bases;
    private final byte[] rcBases;
    private byte[] ignoredBases;
    public static final byte A = 65;
    public static final byte C = 67;
    public static final byte G = 71;
    public static final byte T = 84;

    public TrimSequenceTemplate(String sequence, String ignoredBases) {
        this.sequence = sequence;
        this.reverseComplement = SequenceUtil.reverseComplement((String)this.sequence);
        this.bases = StringUtil.stringToBytes((String)this.sequence);
        this.rcBases = StringUtil.stringToBytes((String)this.reverseComplement);
        this.ignoredBases = StringUtil.stringToBytes((String)ignoredBases);
    }

    public TrimSequenceTemplate(String barcode) {
        this.sequence = barcode;
        this.reverseComplement = SequenceUtil.reverseComplement((String)this.sequence);
        this.bases = StringUtil.stringToBytes((String)this.sequence);
        this.rcBases = StringUtil.stringToBytes((String)this.reverseComplement);
        this.ignoredBases = StringUtil.stringToBytes((String)"Nn");
    }

    public String getSequence() {
        return this.sequence;
    }

    public String reverseComplement() {
        return this.reverseComplement;
    }

    public boolean hasForwardMatch(String testString) {
        byte[] testBases = StringUtil.stringToBytes((String)testString);
        int numBasesCanMatch = 0;
        int numBasesMatch = 0;
        for (int i = 0; i < this.bases.length; ++i) {
            if (this.isIgnoreBase(this.bases[i])) continue;
            ++numBasesCanMatch;
            if (!SequenceUtil.basesEqual((byte)testBases[i], (byte)this.bases[i])) continue;
            ++numBasesMatch;
        }
        return numBasesCanMatch == numBasesMatch;
    }

    public int getPositionInTemplate(String testString, int minMatch, int mismatchesAllowed) {
        byte[] read = StringUtil.stringToBytes((String)testString);
        if (read == null || read.length < minMatch) {
            return -1;
        }
        block0: for (int start = 0; start < this.bases.length; ++start) {
            int length = Math.min(this.bases.length - start, read.length);
            int mismatches = 0;
            for (int i = 0; i < length; ++i) {
                int idx = i + start;
                if (!SequenceUtil.isNoCall((byte)this.bases[i]) && !SequenceUtil.basesEqual((byte)this.bases[idx], (byte)read[i]) && ++mismatches > mismatchesAllowed) continue block0;
            }
            int lengthMatch = this.bases.length - start - mismatches;
            if (lengthMatch < minMatch) {
                return -1;
            }
            return start;
        }
        return -1;
    }

    public int getPositionInRead(String testString, int minMatch, int mismatchesAllowed) {
        byte[] read = StringUtil.stringToBytes((String)testString);
        if (read == null || read.length < minMatch) {
            return -1;
        }
        int maxNumMatches = 0;
        int bestReadStartPos = 0;
        int lastViableReadIndex = read.length - minMatch + 1;
        block0: for (int readIndex = 0; readIndex < lastViableReadIndex; ++readIndex) {
            int mismatches = 0;
            int numMatches = 0;
            int searchLength = Math.min(this.bases.length, read.length - readIndex);
            if (searchLength < minMatch) break;
            for (int templateIndex = 0; templateIndex < searchLength; ++templateIndex) {
                int tempReadIndex = templateIndex + readIndex;
                if (SequenceUtil.isNoCall((byte)read[tempReadIndex]) || SequenceUtil.basesEqual((byte)this.bases[templateIndex], (byte)read[tempReadIndex])) {
                    if (++mismatches > mismatchesAllowed) {
                        continue block0;
                    }
                } else {
                    ++numMatches;
                }
                if (numMatches <= maxNumMatches) continue;
                maxNumMatches = numMatches;
                bestReadStartPos = readIndex;
            }
        }
        if (maxNumMatches < minMatch) {
            return -1;
        }
        return bestReadStartPos;
    }

    public static int findBarcodeIndexReverseMatch(String readString, String barcode) {
        String bc = SequenceUtil.reverseComplement((String)barcode);
        int index = readString.indexOf(bc);
        if (index > -1) {
            ++index;
        }
        return index;
    }

    public boolean isIgnoreBase(Byte base) {
        return TrimSequenceTemplate.baseInBaseList(base, this.ignoredBases);
    }

    public static boolean baseInBaseList(Byte base, byte[] baseList) {
        byte[] byArray = baseList;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte b = byArray[i];
            if (!SequenceUtil.basesEqual((byte)b, (byte)base)) continue;
            return true;
        }
        return false;
    }

    public byte[] getIgnoredBases() {
        return this.ignoredBases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<TrimSequenceTemplate> parseBarcodesFromFile(File f) {
        ArrayList<TrimSequenceTemplate> result = new ArrayList<TrimSequenceTemplate>();
        try (BufferedReader input = new BufferedReader(new FileReader(f));){
            String line = null;
            while ((line = input.readLine()) != null) {
                String[] strLine = line.split("\t");
                TrimSequenceTemplate b = new TrimSequenceTemplate(strLine[0]);
                result.add(b);
            }
        }
        catch (IOException ex) {
            throw new TranscriptomeException("Could not read file: " + f.toString());
        }
        return result;
    }

    public static Collection<TrimSequenceTemplate> expandBarcode(TrimSequenceTemplate b, byte[] ignoredBases) {
        ArrayList<TrimSequenceTemplate> result = new ArrayList<TrimSequenceTemplate>();
        result.add(b);
        byte[] bases = StringUtil.stringToBytes((String)b.getSequence());
        for (int i = 0; i < bases.length; ++i) {
            boolean ignoreBaseFound = TrimSequenceTemplate.baseInBaseList(bases[i], ignoredBases);
            if (!ignoreBaseFound) continue;
            result.remove(b);
            bases[i] = 65;
            TrimSequenceTemplate newBC = new TrimSequenceTemplate(StringUtil.bytesToString((byte[])bases), StringUtil.bytesToString((byte[])ignoredBases));
            Collection<TrimSequenceTemplate> r = TrimSequenceTemplate.expandBarcode(newBC, ignoredBases);
            result.addAll(r);
            bases[i] = 67;
            newBC = new TrimSequenceTemplate(StringUtil.bytesToString((byte[])bases), StringUtil.bytesToString((byte[])ignoredBases));
            r = TrimSequenceTemplate.expandBarcode(newBC, ignoredBases);
            result.addAll(r);
            bases[i] = 71;
            newBC = new TrimSequenceTemplate(StringUtil.bytesToString((byte[])bases), StringUtil.bytesToString((byte[])ignoredBases));
            r = TrimSequenceTemplate.expandBarcode(newBC, ignoredBases);
            result.addAll(r);
            bases[i] = 84;
            newBC = new TrimSequenceTemplate(StringUtil.bytesToString((byte[])bases), StringUtil.bytesToString((byte[])ignoredBases));
            r = TrimSequenceTemplate.expandBarcode(newBC, ignoredBases);
            result.addAll(r);
            break;
        }
        return result;
    }

    public String toString() {
        return this.sequence;
    }
}

