/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BaseRange {
    private int start;
    private int end;

    public BaseRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int getSize() {
        int r = this.getEnd() - this.getStart() + 1;
        return r;
    }

    public static int getTotalRangeSize(String baseRange) {
        List<BaseRange> result = BaseRange.parseBaseRange(baseRange);
        int totalSize = 0;
        for (BaseRange b : result) {
            int s = b.getSize();
            totalSize += s;
        }
        return totalSize;
    }

    public static List<BaseRange> parseBaseRange(String baseRange) {
        String[] split = baseRange.split(":");
        ArrayList<BaseRange> result = new ArrayList<BaseRange>(split.length);
        for (String s : split) {
            BaseRange r = BaseRange.parseSingleBaseRange(s);
            result.add(r);
        }
        return result;
    }

    public static BaseRange parseSingleBaseRange(String baseRange) {
        baseRange.replaceAll("\\s+", "");
        baseRange = BaseRange.sanitizeString(baseRange);
        String[] split = baseRange.split("-");
        if (split.length != 2) {
            throw new IllegalArgumentException("Unable to split input base range into a start and end location: " + baseRange + " Please format your base range input properly.");
        }
        BaseRange r = new BaseRange(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
        return r;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public static String getSequenceForBaseRange(List<BaseRange> baseRange, String sequence) {
        StringBuilder result = new StringBuilder();
        for (BaseRange b : baseRange) {
            String s = sequence.substring(b.start - 1, b.end);
            result.append(s);
        }
        return result.toString();
    }

    public static byte[] getBytesForBaseRange(List<BaseRange> baseRange, byte[] sequence) {
        int rangeSize = BaseRange.getTotalRangeSize(baseRange);
        byte[] result = new byte[rangeSize];
        int destPos = 0;
        for (BaseRange b : baseRange) {
            byte[] subList = Arrays.copyOfRange(sequence, b.start - 1, b.end);
            System.arraycopy(subList, 0, result, destPos, subList.length);
            destPos += subList.length;
        }
        return result;
    }

    public static String sanitizeString(String input) {
        StringBuilder result = new StringBuilder();
        for (char val : input.toCharArray()) {
            if ((val < '0' || val > '9') && val != '-') continue;
            result.append(val);
        }
        return result.toString();
    }

    public static List<BaseRange> invert(List<BaseRange> baseRanges, int sequenceLength) {
        ArrayList<BaseRange> result = new ArrayList<BaseRange>();
        Integer lastCoveredPosition = 0;
        for (BaseRange i : baseRanges) {
            if (i.getStart() > lastCoveredPosition + 1) {
                result.add(new BaseRange(lastCoveredPosition + 1, i.getStart() - 1));
            }
            lastCoveredPosition = i.getEnd();
        }
        if (sequenceLength > lastCoveredPosition) {
            result.add(new BaseRange(lastCoveredPosition + 1, sequenceLength));
        }
        return result;
    }

    public static int getTotalRangeSize(List<BaseRange> ranges) {
        int result = 0;
        for (BaseRange br : ranges) {
            int l = br.end - br.start + 1;
            result += l;
        }
        return result;
    }

    public String toString() {
        return new String(this.start + "-" + this.end);
    }
}

