/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import htsjdk.samtools.util.IOUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import picard.PicardException;

public class FastaSequenceFileWriter {
    private int lineLength = 50;
    private BufferedWriter writer = null;

    public FastaSequenceFileWriter(File fastaFile) {
        IOUtil.assertFileIsWritable((File)fastaFile);
        try {
            this.writer = new BufferedWriter(new FileWriter(fastaFile));
        }
        catch (IOException ioe) {
            throw new PicardException("Error creating BufferedWriter " + fastaFile.getAbsolutePath() + ": " + ioe.getMessage(), (Throwable)ioe);
        }
    }

    public FastaSequenceFileWriter(File fastaFile, int lineLength) {
        this(fastaFile);
        this.lineLength = lineLength;
    }

    public void writeSequence(String name, String sequence) {
        try {
            this.writer.write(">" + name);
            this.writer.newLine();
            int startPos = 0;
            do {
                int endPos = Math.min(startPos + this.lineLength, sequence.length());
                this.writer.write(sequence.substring(startPos, endPos));
                this.writer.newLine();
            } while ((startPos += this.lineLength) < sequence.length());
        }
        catch (IOException ioe) {
            throw new PicardException("Error writing to fasta file: " + ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }
}

