/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import picard.cmdline.CommandLineProgram;

public class SamHeaderUtil {
    public static void addPgRecord(SAMFileHeader header, CommandLineProgram clp) {
        int highestIdSeen = -1;
        for (SAMProgramRecord pg : header.getProgramRecords()) {
            try {
                int id = Integer.parseInt(pg.getId());
                if (id <= highestIdSeen) continue;
                highestIdSeen = id;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        SAMProgramRecord pg = new SAMProgramRecord(Integer.toString(highestIdSeen + 1));
        pg.setProgramName(clp.getClass().getSimpleName());
        pg.setCommandLine(clp.getCommandLine());
        pg.setProgramVersion(clp.getVersion());
        header.addProgramRecord(pg);
    }
}

