/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.editdistance;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import org.broadinstitute.dropseqrna.utils.editdistance.CollapseBarcodesTask;

public class CollapseBarcodeThreaded {
    private ForkJoinPool threadpool;
    private final int blockSize;

    public CollapseBarcodeThreaded(int blockSize, Integer numThreads) {
        this.threadpool = numThreads == null ? new ForkJoinPool() : new ForkJoinPool(numThreads);
        this.blockSize = blockSize;
    }

    public Set<String> getStringsWithinEditDistanceWithIndel(String baseString, List<String> comparisonStrings, int editDistance, boolean findIndels) {
        return this.threadpool.invoke(new CollapseBarcodesTask(baseString, comparisonStrings, this.blockSize, editDistance, findIndels));
    }

    public int getNumThreads() {
        return this.threadpool.getParallelism();
    }
}

