/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.editdistance;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IterableAdapter;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.dropseqrna.barnyard.BarcodeListRetrieval;
import org.broadinstitute.dropseqrna.cmdline.DropSeq;
import org.broadinstitute.dropseqrna.metrics.BAMTagHistogram;
import org.broadinstitute.dropseqrna.utils.ObjectCounter;
import org.broadinstitute.dropseqrna.utils.editdistance.CollapseBarcodeThreaded;
import org.broadinstitute.dropseqrna.utils.editdistance.MapBarcodesByEditDistance;
import org.broadinstitute.dropseqrna.utils.readiterators.SamFileMergeUtil;
import org.broadinstitute.dropseqrna.utils.readiterators.SamHeaderAndIterator;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;

@CommandLineProgramProperties(usage="Fold down barcodes, possibly in the context of another barcode (that has been folded down already.)", usageShort="Fold down barcodes, possibly in the context of another barcode (that has been folded down already.)", programGroup=DropSeq.class)
public class CollapseBarcodesInPlace
extends CommandLineProgram {
    private final Log log = Log.getInstance(CollapseBarcodesInPlace.class);
    private ProgressLogger pl = new ProgressLogger(this.log);
    @Option(shortName="I", doc="The input SAM or BAM file to analyze.  Must be coordinate sorted. ", minElements=1)
    public List<File> INPUT;
    @Option(shortName="O", doc="Output BAM file with an extra tag.")
    public File OUTPUT;
    @Option(doc="Barcode to collapse")
    public String PRIMARY_BARCODE;
    @Option(doc="The edit distance to collapse barcodes")
    public Integer EDIT_DISTANCE = 1;
    @Option(doc="Should indels be considered in edit distance calculations?  Doing this correctly is far slower than a simple edit distance test, but gives a more complete result.")
    public boolean FIND_INDELS = true;
    @Option(doc="The output barcode tag for the newly collapsed barcodes")
    public String OUT_BARCODE;
    @Option(doc="Read quality filter.  Filters all reads lower than this mapping quality.  Defaults to 10.  Set to 0 to not filter reads by map quality.")
    public Integer READ_QUALITY = 10;
    @Option(doc="Number of reads a barcode would need to have in order to have other barcodes get merged into it.  All barcodes are candidates to be merged into another barcode.For cell barcodes you probably want to set this to a relatively high number like 100, since we expect cells to have thousands or more reads, and this signficantly speeds up analysis.  For molecular barcodes, you probably want to set this to 1, as you want to include all molecular barcodes, unless you have very high sequencing depth.", optional=true)
    public Integer MIN_NUM_READS_CORE = null;
    @Option(doc="Number of cells that you think are in the library.  This accomplishes the same goals as the MIN_NUM_READS_CORE argument, but instead of defining barcodes as important based on the number of reads, it picks the top <X> barcodes as core.", optional=true)
    public Integer NUM_CORE_BARCODES = null;
    @Option(doc="The number of reads a non-core barcode must have to be merged with a core barcode.", optional=true)
    public Integer MIN_NUM_READS_NONCORE = 1;
    @Option(doc="Filter PCR Duplicates.  Defaults to false")
    public boolean FILTER_PCR_DUPLICATES = false;
    @Option(doc="Number of threads to use.  Defaults to 1.")
    public int NUM_THREADS = 1;
    private int REPORT_PROGRESS_INTERVAL = 100;
    private CollapseBarcodeThreaded cbt = null;
    private int threadedBlockSize = 20000;

    protected int doWork() {
        this.log.info(new Object[]{"Number of cores selected [" + Integer.toString(this.NUM_THREADS) + "]"});
        if (this.NUM_THREADS > 1) {
            this.cbt = new CollapseBarcodeThreaded(this.threadedBlockSize, this.NUM_THREADS);
        }
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        for (File inputFile : this.INPUT) {
            IOUtil.assertFileIsReadable((File)inputFile);
        }
        this.processOnlyPrimary();
        return 0;
    }

    public void processOnlyPrimary() {
        SamHeaderAndIterator inputs = this.openInputs();
        CloseableIterator<SAMRecord> inputSam = inputs.iterator;
        SAMFileHeader header = inputs.header;
        header.addComment("Edit distance collapsed tag " + this.PRIMARY_BARCODE + " to new tag " + this.OUT_BARCODE + " with edit distance " + this.EDIT_DISTANCE);
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(header, true, this.OUTPUT);
        SamHeaderAndIterator inputs2 = this.openInputs();
        ObjectCounter<String> barcodes = new BAMTagHistogram().getBamTagCounts((Iterator<SAMRecord>)inputs2.iterator, this.PRIMARY_BARCODE, (int)this.READ_QUALITY, this.FILTER_PCR_DUPLICATES);
        CloserUtil.close(inputs2.iterator);
        barcodes = this.filterBarcodesByNumReads(barcodes, this.MIN_NUM_READS_NONCORE);
        Map<String, String> childParentBarcodes = this.collapseBarcodes(this.MIN_NUM_READS_CORE, this.NUM_CORE_BARCODES, barcodes, this.FIND_INDELS, this.EDIT_DISTANCE);
        this.retagReads((Iterator<SAMRecord>)inputSam, writer, childParentBarcodes, this.PRIMARY_BARCODE, this.OUT_BARCODE);
        CloserUtil.close(inputSam);
        writer.close();
    }

    private SamHeaderAndIterator openInputs() {
        SamHeaderAndIterator ret = SamFileMergeUtil.mergeInputs(this.INPUT, true);
        if (SAMFileHeader.SortOrder.coordinate != ret.header.getSortOrder()) {
            throw new PicardException("Input files are not coordinate sorted");
        }
        return ret;
    }

    private ObjectCounter<String> filterBarcodesByNumReads(ObjectCounter<String> barcodes, int minNumReads) {
        ObjectCounter<String> result = new ObjectCounter<String>();
        for (String k : barcodes.getKeys()) {
            int count = barcodes.getCountForKey(k);
            if (count < minNumReads) continue;
            result.setCount(k, count);
        }
        this.log.info(new Object[]{"Filtering barcodes by min non-core reads.  Started with [" + barcodes.getSize() + "] ended with [" + result.getSize() + "]"});
        return result;
    }

    private void retagReads(Iterator<SAMRecord> inputSam, SAMFileWriter writer, Map<String, String> collapsed, String tag, String outTag) {
        for (SAMRecord r : new IterableAdapter(inputSam)) {
            this.pl.record(r);
            String s1 = r.getStringAttribute(tag);
            String newTag = collapsed.get(s1);
            if (newTag == null) {
                newTag = s1;
            }
            r.setAttribute(outTag, (Object)newTag);
            writer.addAlignment(r);
        }
    }

    private Map<String, String> collapseBarcodes(ObjectCounter<String> barcodes, boolean findIndels, int editDistance) {
        List<String> barcodeList = barcodes.getKeysOrderedByCount(true);
        Map<String, String> result = this.collapseBarcodes(barcodeList, barcodes, findIndels, editDistance);
        return result;
    }

    private Map<String, String> collapseBarcodes(Integer numReadsCore, Integer numCells, ObjectCounter<String> barcodes, boolean findIndels, int editDistance) {
        if (numReadsCore == null && numCells == null) {
            return this.collapseBarcodes(barcodes, findIndels, editDistance);
        }
        List<String> core = null;
        BarcodeListRetrieval u = new BarcodeListRetrieval();
        if (numReadsCore != null) {
            core = u.getCoreBarcodesByReadCount(barcodes, numReadsCore);
        } else if (numCells != null) {
            core = u.getTopCoreBarcodesByReadCount(barcodes, numCells);
        }
        return this.collapseBarcodes(core, barcodes, findIndels, editDistance);
    }

    public Map<String, String> collapseBarcodes(List<String> coreBarcodes, ObjectCounter<String> barcodes, boolean findIndels, int editDistance) {
        HashMap<String, String> result = new HashMap<String, String>();
        MapBarcodesByEditDistance med = new MapBarcodesByEditDistance(true, this.NUM_THREADS, 10000);
        Map<String, List<String>> r = med.collapseBarcodes(coreBarcodes, barcodes, findIndels, editDistance);
        for (String key : r.keySet()) {
            for (String value : r.get(key)) {
                result.put(value, key);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        System.exit(new CollapseBarcodesInPlace().instanceMain(args));
    }
}

