/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.editdistance;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.RecursiveTask;
import org.broadinstitute.dropseqrna.utils.editdistance.HammingDistance;
import org.broadinstitute.dropseqrna.utils.editdistance.LevenshteinDistance;

public class CollapseBarcodesTask
extends RecursiveTask<Set<String>> {
    private static final long serialVersionUID = 1358460693439743534L;
    private String baseString;
    private List<String> comparisonStrings;
    private int splitSize = 1000;
    private int editDistance;
    private int threshold;
    private boolean findIndels;

    public CollapseBarcodesTask(String baseString, List<String> comparisonStrings, int splitSize, int editDistance, boolean findIndels) {
        this.baseString = baseString;
        this.comparisonStrings = comparisonStrings;
        this.splitSize = splitSize;
        this.editDistance = editDistance;
        this.findIndels = findIndels;
    }

    @Override
    protected Set<String> compute() {
        int size = this.comparisonStrings.size();
        if (size > this.splitSize) {
            int midpoint = size / 2;
            List<String> n1 = this.comparisonStrings.subList(0, midpoint);
            List<String> n2 = this.comparisonStrings.subList(midpoint, size - 1);
            CollapseBarcodesTask t1 = new CollapseBarcodesTask(this.baseString, n1, this.splitSize, this.editDistance, this.findIndels);
            CollapseBarcodesTask t2 = new CollapseBarcodesTask(this.baseString, n2, this.splitSize, this.editDistance, this.findIndels);
            t1.fork();
            Object result = t2.compute();
            result.addAll((Collection)t1.join());
            return result;
        }
        HashSet<String> result = new HashSet<String>();
        for (String b : this.comparisonStrings) {
            int ed = this.findIndels ? LevenshteinDistance.getIndelSlidingWindowEditDistance(this.baseString, b, this.threshold) : HammingDistance.getHammingDistance(this.baseString, b);
            if (ed > this.editDistance) continue;
            result.add(b);
        }
        return result;
    }
}

