/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.editdistance;

import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import org.broadinstitute.dropseqrna.utils.ObjectCounter;
import org.broadinstitute.dropseqrna.utils.editdistance.BarcodeWithCount;
import org.broadinstitute.dropseqrna.utils.editdistance.EDUtils;
import org.broadinstitute.dropseqrna.utils.editdistance.HammingDistance;
import org.broadinstitute.dropseqrna.utils.editdistance.LevenshteinDistance;

public class MapBarcodesByEditDistance {
    private final int NUM_THREADS;
    private final Log log = Log.getInstance(MapBarcodesByEditDistance.class);
    private final int REPORT_PROGRESS_INTERVAL;
    private final boolean verbose;
    private ForkJoinPool forkJoinPool;

    public MapBarcodesByEditDistance(boolean verbose, int numThreads, int reportProgressInterval) {
        this.verbose = verbose;
        this.NUM_THREADS = numThreads;
        this.REPORT_PROGRESS_INTERVAL = reportProgressInterval;
        if (this.NUM_THREADS > 1) {
            this.forkJoinPool = new ForkJoinPool(numThreads);
        }
    }

    public MapBarcodesByEditDistance(boolean verbose, int reportProgressInterval) {
        this(verbose, 1, reportProgressInterval);
    }

    public MapBarcodesByEditDistance(boolean verbose) {
        this(verbose, 1, 100000);
    }

    public Map<String, List<String>> collapseBarcodes(ObjectCounter<String> barcodes, boolean findIndels, int editDistance) {
        List<String> coreBarcodes = barcodes.getKeysOrderedByCount(true);
        return this.collapseBarcodes(coreBarcodes, barcodes, findIndels, editDistance);
    }

    public Map<String, List<String>> collapseBarcodes(List<String> coreBarcodes, ObjectCounter<String> barcodes, boolean findIndels, int editDistance) {
        coreBarcodes = new ArrayList<String>(coreBarcodes);
        barcodes = new ObjectCounter<String>(barcodes);
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        int count = 0;
        int numBCCollapsed = 0;
        List<String> barcodeList = barcodes.getKeysOrderedByCount(true);
        int coreBarcodeCount = coreBarcodes.size();
        long startTime = System.currentTimeMillis();
        while (!coreBarcodes.isEmpty()) {
            String b = coreBarcodes.get(0);
            ++count;
            coreBarcodes.remove(b);
            barcodeList.remove(b);
            Set<String> closeBC = this.processSingleBarcode(b, barcodeList, findIndels, editDistance);
            numBCCollapsed += closeBC.size();
            if (result.containsKey(b)) {
                this.log.error(new Object[]{"Result should never have core barcode"});
            }
            ArrayList<String> closeBCList = new ArrayList<String>(closeBC);
            Collections.sort(closeBCList);
            result.put(b, closeBCList);
            barcodeList.removeAll(closeBC);
            coreBarcodes.removeAll(closeBC);
            if (this.REPORT_PROGRESS_INTERVAL == 0 || count % this.REPORT_PROGRESS_INTERVAL != 0) continue;
            if (barcodes.getSize() > 10000) {
                this.log.info(new Object[]{"Processed [" + count + "] records, totals BC Space left [" + barcodeList.size() + "]", " # collapsed this set [" + numBCCollapsed + "]"});
            }
            numBCCollapsed = 0;
        }
        if (this.verbose) {
            long endTime = System.currentTimeMillis();
            long duration = (endTime - startTime) / 1000L;
            this.log.info(new Object[]{"Collapse with [" + this.NUM_THREADS + "] threads took [" + duration + "] seconds to process"});
            this.log.info(new Object[]{"Started with core barcodes [" + coreBarcodeCount + "] ended with [" + count + "] num collapsed [" + (coreBarcodeCount - count) + "]"});
        }
        return result;
    }

    private Set<String> processSingleBarcode(String barcode, List<String> comparisonBarcodes, boolean findIndels, int editDistance) {
        Set<String> closeBarcodes = null;
        if (this.NUM_THREADS > 1) {
            closeBarcodes = this.processSingleBarcodeMultithreaded(barcode, comparisonBarcodes, findIndels, editDistance);
            return closeBarcodes;
        }
        closeBarcodes = findIndels ? EDUtils.getInstance().getStringsWithinEditDistanceWithIndel(barcode, comparisonBarcodes, editDistance) : EDUtils.getInstance().getStringsWithinEditDistance(barcode, comparisonBarcodes, editDistance);
        return closeBarcodes;
    }

    private Set<String> processSingleBarcodeMultithreaded(String barcode, List<String> comparisonBarcodes, boolean findIndels, int editDistance) {
        Set<String> result = new HashSet<String>();
        try {
            result = findIndels ? (Set)((ForkJoinTask)this.forkJoinPool.submit(() -> comparisonBarcodes.parallelStream().filter(x -> LevenshteinDistance.getIndelSlidingWindowEditDistance(barcode, x) <= editDistance).collect(Collectors.toSet()))).get() : (Set)((ForkJoinTask)this.forkJoinPool.submit(() -> comparisonBarcodes.stream().filter(x -> HammingDistance.getHammingDistance(barcode, x) <= editDistance).collect(Collectors.toSet()))).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<BarcodeWithCount> getBarcodesWithCounts(ObjectCounter<String> barcodes) {
        ArrayList<BarcodeWithCount> result = new ArrayList<BarcodeWithCount>();
        List<String> keys = barcodes.getKeysOrderedByCount(true);
        for (String k : keys) {
            BarcodeWithCount b = new BarcodeWithCount(k, barcodes.getCountForKey(k));
            result.add(b);
        }
        return result;
    }
}

