/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.readiterators;

import htsjdk.samtools.SAMRecord;
import java.util.Iterator;
import org.broadinstitute.dropseqrna.utils.FilteredIterator;

public class MapQualityFilteredIterator
extends FilteredIterator<SAMRecord> {
    private final Integer mapQuality;
    private final boolean rejectNonPrimaryReads;

    public MapQualityFilteredIterator(Iterator<SAMRecord> underlyingIterator, Integer mapQuality, boolean rejectNonPrimaryReads) {
        super(underlyingIterator);
        this.mapQuality = mapQuality;
        this.rejectNonPrimaryReads = rejectNonPrimaryReads;
    }

    @Override
    public boolean filterOut(SAMRecord r) {
        boolean flag = this.rejectNonPrimaryReads && r.isSecondaryOrSupplementary() || this.mapQuality != null && r.getMappingQuality() < this.mapQuality;
        return flag;
    }
}

