/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.readiterators;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.broadinstitute.dropseqrna.barnyard.Utils;
import org.broadinstitute.dropseqrna.barnyard.digitalexpression.UMICollection;
import org.broadinstitute.dropseqrna.utils.GroupingIterator;
import org.broadinstitute.dropseqrna.utils.MultiComparator;
import org.broadinstitute.dropseqrna.utils.StringInterner;
import org.broadinstitute.dropseqrna.utils.StringTagComparator;
import org.broadinstitute.dropseqrna.utils.readiterators.MissingTagFilteringIterator;
import org.broadinstitute.dropseqrna.utils.readiterators.SamHeaderAndIterator;
import org.broadinstitute.dropseqrna.utils.readiterators.SamRecordSortingIteratorFactory;
import org.broadinstitute.dropseqrna.utils.readiterators.UmiIteratorWrapper;

public class UMIIterator
implements CloseableIterator<UMICollection> {
    private static final Log log = Log.getInstance(UMIIterator.class);
    private static final ProgressLogger prog = new ProgressLogger(log);
    private final GroupingIterator<SAMRecord> atoi;
    private final String geneExonTag;
    private final String cellBarcodeTag;
    private final String molecularBarcodeTag;
    private final StringInterner stringCache = new StringInterner();

    public UMIIterator(SamHeaderAndIterator headerAndIterator, String geneExonTag, String cellBarcodeTag, String molecularBarcodeTag, String strandTag, int readMQ, boolean assignReadsToAllGenes, boolean useStrandInfo, Collection<String> cellBarcodes) {
        this(headerAndIterator, geneExonTag, cellBarcodeTag, molecularBarcodeTag, strandTag, readMQ, assignReadsToAllGenes, useStrandInfo, cellBarcodes, false);
    }

    public UMIIterator(SamHeaderAndIterator headerAndIterator, String geneExonTag, String cellBarcodeTag, String molecularBarcodeTag, String strandTag, int readMQ, boolean assignReadsToAllGenes, boolean useStrandInfo, Collection<String> cellBarcodes, boolean cellFirstSort) {
        this.geneExonTag = geneExonTag;
        this.cellBarcodeTag = cellBarcodeTag;
        this.molecularBarcodeTag = molecularBarcodeTag;
        StringTagComparator cellBarcodeTagComparator = new StringTagComparator(cellBarcodeTag);
        StringTagComparator geneExonTagComparator = new StringTagComparator(geneExonTag);
        MultiComparator<Object> multiComparator = cellFirstSort ? new MultiComparator<SAMRecord>(cellBarcodeTagComparator, geneExonTagComparator) : new MultiComparator(geneExonTagComparator, cellBarcodeTagComparator);
        MissingTagFilteringIterator filteringIterator = new MissingTagFilteringIterator((Iterator<SAMRecord>)headerAndIterator.iterator, cellBarcodeTag, geneExonTag, molecularBarcodeTag);
        UmiIteratorWrapper umiIteratorWrapper = new UmiIteratorWrapper(filteringIterator.iterator(), cellBarcodeTag, cellBarcodes, geneExonTag, strandTag, readMQ, assignReadsToAllGenes, useStrandInfo);
        CloseableIterator<SAMRecord> sortedAlignmentIterator = SamRecordSortingIteratorFactory.create(headerAndIterator.header, (Iterator<SAMRecord>)((Object)umiIteratorWrapper), multiComparator, prog);
        log.info(new Object[]{"Sorting finished."});
        this.atoi = new GroupingIterator<SAMRecord>((Iterator<SAMRecord>)sortedAlignmentIterator, (Comparator<SAMRecord>)multiComparator);
    }

    public UMICollection next() {
        if (!this.atoi.hasNext()) {
            return null;
        }
        Object records = this.atoi.next();
        PeekableIterator recordCollectionIter = new PeekableIterator(records.iterator());
        SAMRecord r = (SAMRecord)recordCollectionIter.peek();
        String currentGene = r.getStringAttribute(this.geneExonTag);
        String currentCell = Utils.getCellBC(r, this.cellBarcodeTag);
        UMICollection umi = new UMICollection(currentCell, currentGene);
        while (recordCollectionIter.hasNext()) {
            r = (SAMRecord)recordCollectionIter.next();
            String molecularBarcode = this.stringCache.intern(r.getStringAttribute(this.molecularBarcodeTag));
            umi.incrementMolecularBarcodeCount(molecularBarcode);
        }
        recordCollectionIter.close();
        return umi;
    }

    public void remove() {
        this.atoi.remove();
    }

    public void close() {
        CloserUtil.close(this.atoi);
    }

    public boolean hasNext() {
        return this.atoi.hasNext();
    }
}

