/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.linear;

import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.linear.LinearSystemSolver;

public abstract class AbstractSolver
implements LinearSystemSolver {
    protected Matrix a;
    protected int unknowns;
    protected int equations;

    protected AbstractSolver(Matrix a) {
        if (!this.applicableTo(a)) {
            this.fail("Given coefficient matrix can not be used with this solver.");
        }
        this.a = a;
        this.unknowns = a.columns();
        this.equations = a.rows();
    }

    @Override
    public Matrix self() {
        return this.a;
    }

    @Override
    public int unknowns() {
        return this.unknowns;
    }

    @Override
    public int equations() {
        return this.equations;
    }

    protected void ensureRHSIsCorrect(Vector vector) {
        if (vector.length() != this.equations) {
            this.fail("Wrong length of RHS vector: " + vector.length() + ".");
        }
    }

    protected void fail(String message) {
        throw new IllegalArgumentException(message);
    }
}

