/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.linear;

import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.linear.AbstractSolver;
import org.la4j.linear.LinearSystemSolver;
import org.la4j.matrix.functor.MatrixFunction;

public class SeidelSolver
extends AbstractSolver
implements LinearSystemSolver {
    private static final long serialVersionUID = 4071505L;
    private final Matrix aa;

    public SeidelSolver(Matrix a) {
        super(a);
        this.aa = a.copy();
        for (int i = 0; i < this.aa.rows(); ++i) {
            MatrixFunction divider = Matrices.asDivFunction(this.aa.get(i, i));
            for (int j = 0; j < this.aa.columns(); ++j) {
                if (i == j) continue;
                this.aa.updateAt(i, j, divider);
            }
        }
    }

    @Override
    public Vector solve(Vector b) {
        this.ensureRHSIsCorrect(b);
        Vector current = b.blankOfLength(this.unknowns());
        while (!this.a.multiply(current).equals(b)) {
            for (int i = 0; i < this.aa.rows(); ++i) {
                double acc = b.get(i) / this.aa.get(i, i);
                for (int j = 0; j < this.aa.columns(); ++j) {
                    if (i == j) continue;
                    acc -= this.aa.get(i, j) * current.get(j);
                }
                current.set(i, acc);
            }
        }
        return current;
    }

    @Override
    public boolean applicableTo(Matrix matrix) {
        return matrix.is(Matrices.DIAGONALLY_DOMINANT_MATRIX);
    }
}

