/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.operation;

import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.matrix.ColumnMajorSparseMatrix;
import org.la4j.matrix.DenseMatrix;
import org.la4j.matrix.RowMajorSparseMatrix;
import org.la4j.operation.MatrixOperation;
import org.la4j.vector.DenseVector;
import org.la4j.vector.SparseVector;

public abstract class VectorMatrixOperation<R> {
    public abstract R apply(SparseVector var1, DenseMatrix var2);

    public abstract R apply(SparseVector var1, RowMajorSparseMatrix var2);

    public abstract R apply(SparseVector var1, ColumnMajorSparseMatrix var2);

    public abstract R apply(DenseVector var1, DenseMatrix var2);

    public abstract R apply(DenseVector var1, RowMajorSparseMatrix var2);

    public abstract R apply(DenseVector var1, ColumnMajorSparseMatrix var2);

    public void ensureApplicableTo(Vector a, Matrix b) {
    }

    public MatrixOperation<R> partiallyApply(final SparseVector a) {
        return new MatrixOperation<R>(){

            @Override
            public R apply(DenseMatrix b) {
                return VectorMatrixOperation.this.apply(a, b);
            }

            @Override
            public R apply(RowMajorSparseMatrix b) {
                return VectorMatrixOperation.this.apply(a, b);
            }

            @Override
            public R apply(ColumnMajorSparseMatrix b) {
                return VectorMatrixOperation.this.apply(a, b);
            }

            @Override
            public void ensureApplicableTo(Matrix b) {
                VectorMatrixOperation.this.ensureApplicableTo(a, b);
            }
        };
    }

    public MatrixOperation<R> partiallyApply(final DenseVector a) {
        return new MatrixOperation<R>(){

            @Override
            public R apply(DenseMatrix b) {
                return VectorMatrixOperation.this.apply(a, b);
            }

            @Override
            public R apply(RowMajorSparseMatrix b) {
                return VectorMatrixOperation.this.apply(a, b);
            }

            @Override
            public R apply(ColumnMajorSparseMatrix b) {
                return VectorMatrixOperation.this.apply(a, b);
            }

            @Override
            public void ensureApplicableTo(Matrix b) {
                VectorMatrixOperation.this.ensureApplicableTo(a, b);
            }
        };
    }
}

