/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.operation.ooplace;

import org.la4j.Vector;
import org.la4j.iterator.VectorIterator;
import org.la4j.operation.SymmetricVectorVectorOperation;
import org.la4j.vector.DenseVector;
import org.la4j.vector.SparseVector;

public class OoPlaceVectorHadamardProduct
extends SymmetricVectorVectorOperation<Vector> {
    @Override
    public Vector apply(SparseVector a, SparseVector b) {
        VectorIterator these = a.nonZeroIterator();
        VectorIterator those = b.nonZeroIterator();
        VectorIterator both = these.andAlsoMultiply(those);
        Vector result = a.blank();
        while (both.hasNext()) {
            double x = (Double)both.next();
            int i = both.index();
            result.set(i, x);
        }
        return result;
    }

    @Override
    public Vector apply(DenseVector a, DenseVector b) {
        Vector result = a.blank();
        for (int i = 0; i < a.length(); ++i) {
            result.set(i, a.get(i) * b.get(i));
        }
        return result;
    }

    @Override
    public Vector applySymmetric(DenseVector a, SparseVector b) {
        Vector result = b.blank();
        VectorIterator it = b.nonZeroIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            result.set(i, x * a.get(i));
        }
        return result;
    }

    @Override
    public void ensureApplicableTo(Vector a, Vector b) {
        if (a.length() != b.length()) {
            throw new IllegalArgumentException("Given vectors should have the same length: " + a.length() + " does not equal to " + b.length() + ".");
        }
    }
}

