/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.simpleframework.xml.stream.InputAttribute;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.NodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InputNodeMap
extends LinkedHashMap<String, InputNode>
implements NodeMap<InputNode> {
    private InputNode source;

    protected InputNodeMap(InputNode source) {
        this.source = source;
    }

    public InputNodeMap(InputNode source, StartElement element) {
        this.source = source;
        this.put(element);
    }

    @Override
    public String getName() {
        return this.source.getName();
    }

    private void put(StartElement element) {
        Iterator<Attribute> list = element.getAttributes();
        while (list.hasNext()) {
            Attribute event = list.next();
            if (!(event instanceof Attribute)) continue;
            this.put(event);
        }
    }

    private InputNode put(Attribute event) {
        InputAttribute node = new InputAttribute(this.source, event);
        String name = node.getName();
        if (name != null) {
            this.put(name, node);
        }
        return node;
    }

    @Override
    public InputNode put(String name, String value) {
        InputAttribute node = new InputAttribute(this.source, name, value);
        if (name != null) {
            this.put(name, node);
        }
        return node;
    }

    @Override
    public InputNode remove(String name) {
        return (InputNode)super.remove(name);
    }

    @Override
    public InputNode get(String name) {
        return (InputNode)super.get(name);
    }

    @Override
    public Iterator<String> iterator() {
        return this.keySet().iterator();
    }
}

