/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment.aaindex;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.biojava.nbio.alignment.SubstitutionMatrixHelper;
import org.biojava.nbio.alignment.aaindex.AAIndexFileParser;
import org.biojava.nbio.alignment.aaindex.AAIndexProvider;
import org.biojava.nbio.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAAIndexProvider
implements AAIndexProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAAIndexProvider.class);
    Map<String, SubstitutionMatrix<AminoAcidCompound>> matrices;

    public DefaultAAIndexProvider() {
        InputStream inStream = this.getInputStreamToAAindexFile();
        AAIndexFileParser parser = new AAIndexFileParser();
        try {
            parser.parse(inStream);
        }
        catch (IOException e) {
            logger.error("Exception: ", (Throwable)e);
        }
        this.matrices = parser.getMatrices();
    }

    @Override
    public SubstitutionMatrix<AminoAcidCompound> getMatrix(String matrixName) {
        return this.matrices.get(matrixName);
    }

    public InputStream getInputStreamToAAindexFile() {
        return SubstitutionMatrixHelper.class.getResourceAsStream(String.format("/AAINDEX.txt", new Object[0]));
    }
}

