/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.annotation;

import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GQuadruplex {
    private Interval interval;
    private String[] sequence;
    private static String patternString = "([gG]{3,})([acgtACGT]{1,7})([gG]{3,})([acgtACGT]{1,7})([gG]{3,})([acgtACGT]{1,7})([gG]{3,})";
    private static Pattern pattern = Pattern.compile(patternString);

    public GQuadruplex(Interval i, String G1, String L1, String G2, String L2, String G3, String L3, String G4) {
        this.interval = i;
        this.sequence = new String[7];
        this.sequence[0] = G1;
        this.sequence[1] = L1;
        this.sequence[2] = G2;
        this.sequence[3] = L2;
        this.sequence[4] = G3;
        this.sequence[5] = L3;
        this.sequence[6] = G4;
    }

    public Interval getMatchInterval() {
        return this.interval;
    }

    public String getG1() {
        return this.sequence[0];
    }

    public String getG2() {
        return this.sequence[2];
    }

    public String getG3() {
        return this.sequence[4];
    }

    public String getG4() {
        return this.sequence[6];
    }

    public String getL1() {
        return this.sequence[1];
    }

    public String getL2() {
        return this.sequence[3];
    }

    public String getL3() {
        return this.sequence[5];
    }

    public String getSequence() {
        return StringUtil.join((String)"", (Object[])this.sequence);
    }

    public static List<GQuadruplex> find(String seqName, String seq) {
        Matcher matcher = pattern.matcher(seq);
        ArrayList<GQuadruplex> result = new ArrayList<GQuadruplex>();
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            Interval i = new Interval(seqName, start + 1, end);
            GQuadruplex r = new GQuadruplex(i, matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6), matcher.group(7));
            result.add(r);
        }
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.interval.getContig() + ":" + this.interval.getStart() + "-" + this.interval.getEnd());
        b.append(" " + this.getSequence() + " ");
        b.append(" G1 [" + this.getG1() + "]");
        b.append(" L1 [" + this.getL1() + "]");
        b.append(" G2 [" + this.getG2() + "]");
        b.append(" L2 [" + this.getL2() + "]");
        b.append(" G3 [" + this.getG3() + "]");
        b.append(" L3 [" + this.getL3() + "]");
        b.append(" G4 [" + this.getG4() + "]");
        return b.toString();
    }
}

