/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.barnyard.digitalexpression;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IterableAdapter;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadinstitute.dropseqrna.barnyard.digitalexpression.DgeHeader;
import org.broadinstitute.dropseqrna.barnyard.digitalexpression.DgeHeaderCommand;
import org.broadinstitute.dropseqrna.barnyard.digitalexpression.DgeHeaderLibrary;

public class DgeHeaderCodec {
    private static final Log log = Log.getInstance(DgeHeaderCodec.class);
    private static char RECORD_START = (char)64;
    private static String KV_SEPARATOR = ":";
    private static String FIELD_SEPARATOR = "\t";
    private static String DGE_RECORD_LABEL = "DGE";
    private static String LIBRARY_RECORD_LABEL = "LIBRARY";
    private static String COMMAND_RECORD_LABEL = "COMMAND";

    public void encode(Writer writer, DgeHeader header) {
        this.writeLine(writer, this.buildFirstLine(header));
        for (String prefix : new IterableAdapter(header.iterateLibraries())) {
            this.writeLine(writer, this.buildLibraryLine(header.getLibrary(prefix)));
        }
        for (DgeHeaderCommand command : new IterableAdapter(header.iterateCommands())) {
            this.writeLine(writer, this.buildCommandLine(command));
        }
    }

    public void encode(File file, DgeHeader header) {
        BufferedWriter writer = IOUtil.openFileForBufferedWriting((File)file);
        this.encode(writer, header);
        try {
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception writing " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    private void writeLine(Writer writer, String line) {
        try {
            writer.write(line);
            writer.write(10);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String buildFirstLine(DgeHeader header) {
        OutputRecordBuilder dgeRecord = new OutputRecordBuilder(DGE_RECORD_LABEL);
        dgeRecord.addFieldIfNotNull((Object)DgeRecordTag.VERSION, header.getVersion());
        dgeRecord.addFieldIfNotNull((Object)DgeRecordTag.EXPRESSION_FORMAT, (Object)header.getExpressionFormat());
        return dgeRecord.build();
    }

    private String buildLibraryLine(DgeHeaderLibrary library) {
        OutputRecordBuilder dgeRecord = new OutputRecordBuilder(LIBRARY_RECORD_LABEL);
        dgeRecord.addFieldIfNotNull((Object)LibraryRecordTag.INPUT, library.getInput());
        dgeRecord.addFieldIfNotNull((Object)LibraryRecordTag.INPUT_DGE, library.getInputDge());
        dgeRecord.addFieldIfNotNull((Object)LibraryRecordTag.REFERENCE, library.getReference());
        dgeRecord.addFieldIfNotNull((Object)LibraryRecordTag.UEI, library.getUei());
        dgeRecord.addFieldIfNotNull((Object)LibraryRecordTag.PREFIX, library.getPrefix());
        for (Map.Entry entry : new IterableAdapter(library.iterateOtherTags())) {
            dgeRecord.addFieldIfNotNull(entry.getKey(), entry.getValue());
        }
        return dgeRecord.build();
    }

    private String buildCommandLine(DgeHeaderCommand command) {
        OutputRecordBuilder dgeRecord = new OutputRecordBuilder(COMMAND_RECORD_LABEL);
        dgeRecord.addFieldIfNotNull((Object)CommandRecordTag.CL, command.getCommandLine());
        return dgeRecord.build();
    }

    public DgeHeader decode(BufferedReader reader, String inputName) {
        if (!reader.markSupported()) {
            throw new IllegalArgumentException("reader.markSupported == false");
        }
        return this.decode(new DgeBufferedReader(reader), inputName);
    }

    public DgeHeader decode(BufferedInputStream inputStream, String inputName) {
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("reader.markSupported == false");
        }
        return this.decode(new DgeBufferedInputStream(inputStream), inputName);
    }

    private DgeHeader decode(DgeHeaderLineReader reader, String inputName) {
        try {
            String line;
            DgeHeader ret = new DgeHeader();
            ret.setExpressionFormat(DgeHeader.ExpressionFormat.unknown);
            ret.setVersion(null);
            boolean first = true;
            while ((line = reader.readHeaderLine()) != null) {
                if (line.startsWith(DGE_RECORD_LABEL + FIELD_SEPARATOR)) {
                    if (first) {
                        this.parseFirstLine(ret, line, inputName);
                    } else {
                        log.warn(new Object[]{"DGE header line seen after first line in " + inputName});
                    }
                } else if (line.startsWith(LIBRARY_RECORD_LABEL + FIELD_SEPARATOR)) {
                    DgeHeaderLibrary library = this.parseLibrary(line, inputName);
                    if (library != null) {
                        ret.addLibrary(library);
                    }
                } else if (line.startsWith(COMMAND_RECORD_LABEL + FIELD_SEPARATOR)) {
                    DgeHeaderCommand command = this.parseCommand(line, inputName);
                    if (command != null) {
                        ret.addCommand(command);
                    }
                } else {
                    log.warn(new Object[]{"Strange DGE header line seen in " + inputName + ";" + line});
                }
                first = false;
            }
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException("Problem parsing " + inputName, e);
        }
    }

    private boolean isHeaderLine(BufferedReader reader) throws IOException {
        reader.mark(1);
        int c = reader.read();
        if (c == RECORD_START) {
            return true;
        }
        reader.reset();
        return false;
    }

    private void parseFirstLine(DgeHeader header, String line, String inputName) {
        LinkedHashMap<String, String> fields = this.parseLine(line, DGE_RECORD_LABEL, inputName);
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equals(DgeRecordTag.VERSION.name())) {
                header.setVersion(value);
                continue;
            }
            if (key.equals(DgeRecordTag.EXPRESSION_FORMAT.name())) {
                try {
                    header.setExpressionFormat(DgeHeader.ExpressionFormat.valueOf(value));
                }
                catch (IllegalArgumentException e) {
                    log.info(new Object[]{"Unrecognized expression format '" + value + "' in " + inputName});
                }
                continue;
            }
            log.info(new Object[]{"Unrecognized field name '" + key + "' in @DGE record of " + inputName});
        }
    }

    private DgeHeaderLibrary parseLibrary(String line, String inputName) {
        LinkedHashMap<String, String> fields = this.parseLine(line, LIBRARY_RECORD_LABEL, inputName);
        String uei = fields.get(LibraryRecordTag.UEI.name());
        if (uei == null) {
            log.warn(new Object[]{"Ignoring DGE @LIBRARY line missing UEI tag in " + inputName + ";" + line});
            return null;
        }
        DgeHeaderLibrary ret = new DgeHeaderLibrary(uei);
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            try {
                switch (LibraryRecordTag.valueOf(key)) {
                    case INPUT: {
                        ret.setInput(new File(value));
                        break;
                    }
                    case INPUT_DGE: {
                        ret.setInputDge(new File(value));
                        break;
                    }
                    case PREFIX: {
                        ret.setPrefix(value);
                        break;
                    }
                    case REFERENCE: {
                        ret.setReference(new File(value));
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                ret.setTag(key, value);
            }
        }
        return ret;
    }

    private DgeHeaderCommand parseCommand(String line, String inputName) {
        LinkedHashMap<String, String> fields = this.parseLine(line, COMMAND_RECORD_LABEL, inputName);
        String commandLine = fields.get(CommandRecordTag.CL.name());
        if (commandLine == null) {
            log.warn(new Object[]{"Ignoring DGE @COMMAND line missing CL tag in " + inputName + ";" + line});
            return null;
        }
        return new DgeHeaderCommand(commandLine);
    }

    private LinkedHashMap<String, String> parseLine(String line, String recordType, String inputName) {
        String[] fields = line.split(FIELD_SEPARATOR);
        if (!recordType.equals(fields[0])) {
            throw new IllegalStateException("Line did not have expected record type");
        }
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        for (int i = 1; i < fields.length; ++i) {
            String[] kvPair = fields[i].split(KV_SEPARATOR, 2);
            if (kvPair.length != 2) {
                log.warn(new Object[]{"Strange DGE header line seen in " + inputName + ";" + line});
                return null;
            }
            String key = kvPair[0];
            String value = kvPair[1];
            if (key.isEmpty() || value.isEmpty()) {
                log.warn(new Object[]{"Strange key-value pair in DGE header line seen in " + inputName + ";" + line});
                continue;
            }
            if (ret.containsKey(key)) {
                log.warn(new Object[]{"Key " + key + " appears more than once in DGE Header lineseen in " + inputName + ";" + line});
                continue;
            }
            ret.put(key, value);
        }
        return ret;
    }

    private class DgeBufferedInputStream
    implements DgeHeaderLineReader {
        private final BufferedInputStream inputStream;
        private char[] lineBuffer = new char[10000];
        private static final int BUFFER_OVERFLOW_INCREASE_FACTOR = 2;
        private static final byte LINEFEED = 10;
        private static final byte CARRIAGE_RETURN = 13;

        public DgeBufferedInputStream(BufferedInputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public String readHeaderLine() throws IOException {
            this.inputStream.mark(1);
            int c = this.inputStream.read();
            if (c == RECORD_START) {
                return this.readToEndOfLine();
            }
            this.inputStream.reset();
            return null;
        }

        private String readToEndOfLine() throws IOException {
            int linePosition = 0;
            while (true) {
                int b;
                if ((b = this.inputStream.read()) == -1) {
                    if (linePosition > 0) {
                        return new String(this.lineBuffer, 0, linePosition);
                    }
                    return null;
                }
                char c = (char)(b & 0xFF);
                if (c == '\n' || c == '\r') {
                    if (c == '\r' && this.peek() == 10) {
                        this.inputStream.read();
                    }
                    return new String(this.lineBuffer, 0, linePosition);
                }
                if (linePosition > this.lineBuffer.length - 3) {
                    char[] temp = new char[2 * this.lineBuffer.length];
                    System.arraycopy(this.lineBuffer, 0, temp, 0, this.lineBuffer.length);
                    this.lineBuffer = temp;
                }
                this.lineBuffer[linePosition++] = c;
            }
        }

        private int peek() throws IOException {
            this.inputStream.mark(1);
            try {
                int n = this.inputStream.read();
                return n;
            }
            finally {
                this.inputStream.reset();
            }
        }
    }

    private class DgeBufferedReader
    implements DgeHeaderLineReader {
        private final BufferedReader reader;

        public DgeBufferedReader(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public String readHeaderLine() throws IOException {
            this.reader.mark(1);
            int c = this.reader.read();
            if (c == RECORD_START) {
                return this.reader.readLine();
            }
            this.reader.reset();
            return null;
        }
    }

    private static interface DgeHeaderLineReader {
        public String readHeaderLine() throws IOException;
    }

    private static class OutputRecordBuilder {
        private final ArrayList<String> fields = new ArrayList();

        public OutputRecordBuilder(String recordType) {
            this.fields.add(RECORD_START + recordType);
        }

        public void addFieldIfNotNull(Object key, Object value) {
            if (value != null) {
                this.fields.add(key + KV_SEPARATOR + value);
            }
        }

        public String build() {
            return StringUtil.join((String)FIELD_SEPARATOR, this.fields);
        }
    }

    private static enum CommandRecordTag {
        CL;

    }

    private static enum LibraryRecordTag {
        INPUT,
        INPUT_DGE,
        REFERENCE,
        UEI,
        PREFIX;

    }

    private static enum DgeRecordTag {
        VERSION,
        EXPRESSION_FORMAT;

    }
}

