/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.metrics;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.dropseqrna.TranscriptomeException;
import org.broadinstitute.dropseqrna.cmdline.DropSeq;
import org.broadinstitute.dropseqrna.metrics.ReadQualityMetrics;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;

@CommandLineProgramProperties(usage="Calculate the number of reads that are in the BAM, that are mapped, mapped + HQ, mapped + HQ + not PCR duplicated", usageShort="Calculate reads that are in the BAM at different mapping qualities.", programGroup=DropSeq.class)
public class GatherReadQualityMetrics
extends CommandLineProgram {
    private final Log log = Log.getInstance(GatherReadQualityMetrics.class);
    @Option(shortName="I", doc="The input SAM or BAM file to analyze.  Must be coordinate sorted.")
    public File INPUT;
    @Option(shortName="O", doc="The file to write stats to.")
    public File OUTPUT;
    @Option(doc="The minimum map quality for a read to be considered high quality")
    public Integer MAP_QUALITY = 10;
    @Option(doc="Optionally aggregate reads by a tag and output per-tag metrics.  The map quality scores histogram will still be computed globally.", optional=true)
    public String TAG = null;
    @Option(doc="Include non-PF reads when gathering metrics")
    public boolean INCLUDE_NON_PF_READS = false;
    private String GLOBAL = "all";

    public static void main(String[] args) {
        System.exit(new GatherReadQualityMetrics().instanceMain(args));
    }

    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        Map<String, ReadQualityMetrics> metricsMap = this.gatherMetrics(this.INPUT);
        MetricsFile outFile = new MetricsFile();
        outFile.addHistogram(metricsMap.get(this.GLOBAL).getHistogram());
        for (ReadQualityMetrics metrics : metricsMap.values()) {
            outFile.addMetric((MetricBase)metrics);
        }
        BufferedWriter w = IOUtil.openFileForBufferedWriting((File)this.OUTPUT);
        outFile.write((Writer)w);
        try {
            w.close();
        }
        catch (IOException io) {
            throw new TranscriptomeException("Problem writing file", io);
        }
        return 0;
    }

    public Map<String, ReadQualityMetrics> gatherMetrics(File inputSamOrBamFile) {
        ProgressLogger p = new ProgressLogger(this.log);
        Map<String, ReadQualityMetrics> result = new HashMap<String, ReadQualityMetrics>();
        ReadQualityMetrics globalMetrics = new ReadQualityMetrics(this.MAP_QUALITY, this.GLOBAL, true);
        SamReader in = SamReaderFactory.makeDefault().open(this.INPUT);
        for (SAMRecord r : in) {
            if (r.getReadFailsVendorQualityCheckFlag() && !this.INCLUDE_NON_PF_READS) continue;
            p.record(r);
            globalMetrics.addRead(r);
            result = this.addMetricsPerTag(r, result);
        }
        CloserUtil.close((Object)in);
        result.put(this.GLOBAL, globalMetrics);
        return result;
    }

    private Map<String, ReadQualityMetrics> addMetricsPerTag(SAMRecord r, Map<String, ReadQualityMetrics> result) {
        if (this.TAG == null) {
            return result;
        }
        String tag = r.getStringAttribute(this.TAG);
        if (tag == null) {
            return result;
        }
        ReadQualityMetrics m = result.get(tag);
        if (m == null) {
            m = new ReadQualityMetrics(this.MAP_QUALITY, tag, false);
            result.put(tag, m);
        }
        m.addRead(r);
        return result;
    }
}

