/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.readtrimming;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.util.SequenceUtil;
import java.util.ArrayList;

public class AdapterDescriptor {
    public static String DEFAULT_ADAPTER = "~XM~XCACGTACTCTGCGTTGCTACCACTG";
    private static char TAG_CHAR = (char)94;
    private static char RC_TAG_CHAR = (char)126;
    private static int TAG_LENGTH = 2;
    private final AdapterElement[] elements;

    private static AdapterElement[] parseAdapterDescriptor(String descriptor) {
        ArrayList<AdapterElement> elements = new ArrayList<AdapterElement>();
        for (int i = 0; i < descriptor.length(); i += TAG_LENGTH) {
            StringBuilder builder = new StringBuilder();
            while (i < descriptor.length() && descriptor.charAt(i) != TAG_CHAR && descriptor.charAt(i) != RC_TAG_CHAR) {
                builder.append(descriptor.charAt(i));
                ++i;
            }
            if (builder.length() > 0) {
                elements.add(new FixedAdapterElement(builder.toString()));
            }
            if (i == descriptor.length()) break;
            boolean reverseComplement = descriptor.charAt(++i) == RC_TAG_CHAR;
            elements.add(new TagAdapterElement(descriptor.substring(i, i + TAG_LENGTH), reverseComplement));
        }
        return elements.toArray(new AdapterElement[elements.size()]);
    }

    public AdapterDescriptor(String descriptor) {
        this.elements = AdapterDescriptor.parseAdapterDescriptor(descriptor);
    }

    public String getAdapterSequence(SAMRecord rec) {
        StringBuilder builder = new StringBuilder();
        for (AdapterElement element : this.elements) {
            builder.append(element.getSequence(rec));
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (AdapterElement element : this.elements) {
            builder.append(element.toString());
        }
        return builder.toString();
    }

    static class TagAdapterElement
    implements AdapterElement {
        private final String stringTag;
        private final short binaryTag;
        private final boolean reverseComplement;

        TagAdapterElement(String tag, boolean reverseComplement) {
            this.stringTag = tag;
            this.binaryTag = SAMTagUtil.getSingleton().makeBinaryTag(tag);
            this.reverseComplement = reverseComplement;
        }

        @Override
        public String getSequence(SAMRecord rec) {
            return SequenceUtil.reverseComplement((String)((String)rec.getAttribute(this.binaryTag)));
        }

        public String toString() {
            return (this.reverseComplement ? RC_TAG_CHAR : TAG_CHAR) + this.stringTag;
        }
    }

    static class FixedAdapterElement
    implements AdapterElement {
        private final String sequence;

        FixedAdapterElement(String sequence) {
            this.sequence = sequence;
        }

        @Override
        public String getSequence(SAMRecord rec) {
            return this.sequence;
        }

        public String toString() {
            return this.sequence;
        }
    }

    static interface AdapterElement {
        public String getSequence(SAMRecord var1);
    }
}

