/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.readtrimming;

import htsjdk.samtools.SAMRecord;

public interface PolyAFinder {
    public static final int NO_MATCH = -1;

    public PolyARun getPolyAStart(SAMRecord var1);

    public static class PolyARun {
        public final int startPos;
        public final int length;
        public final int adapterStartPos;
        public static PolyARun NO_MATCH_RUN = new PolyARun(-1, 0);

        public PolyARun(int startPos, int length) {
            this(startPos, length, -1);
        }

        public PolyARun(int startPos, int length, int adapterStartPos) {
            this.startPos = startPos;
            this.length = length;
            this.adapterStartPos = adapterStartPos;
        }

        public int endPos() {
            return this.startPos + this.length - 1;
        }

        boolean isNoMatch() {
            return this.startPos == -1;
        }
    }
}

