/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.readtrimming;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.StringUtil;
import org.broadinstitute.dropseqrna.readtrimming.AdapterDescriptor;
import org.broadinstitute.dropseqrna.readtrimming.PolyAFinder;
import picard.util.ClippingUtility;

public class PolyAWithAdapterFinder
implements PolyAFinder {
    private static char A = (char)65;
    private final AdapterDescriptor adapter;
    private final int minAdapterMatch;
    private final double maxAdapterErrorRate;
    private final int minPolyALength;
    private final int minPolyALengthNoAdapterMatch;
    private final double maxPolyAErrorRate;
    private final int dubiousAdapterMatchLength;

    public PolyAWithAdapterFinder(AdapterDescriptor adapter, int minAdapterMatch, double maxAdapterErrorRate, int minPolyALength, int minPolyALengthNoAdapterMatch, double maxPolyAErrorRate, int dubiousAdapterMatchLength) {
        this.adapter = adapter;
        this.minAdapterMatch = minAdapterMatch;
        this.maxAdapterErrorRate = maxAdapterErrorRate;
        this.minPolyALength = minPolyALength;
        this.minPolyALengthNoAdapterMatch = minPolyALengthNoAdapterMatch;
        this.maxPolyAErrorRate = maxPolyAErrorRate;
        this.dubiousAdapterMatchLength = dubiousAdapterMatchLength;
    }

    @Override
    public PolyAFinder.PolyARun getPolyAStart(SAMRecord r) {
        return this.getPolyAStart(r.getReadString(), this.adapter.getAdapterSequence(r));
    }

    public PolyAFinder.PolyARun getPolyAStart(String readString, String adapterSequence) {
        PolyAFinder.PolyARun tryWithoutAdapter;
        byte[] readBases = StringUtil.stringToBytes((String)readString);
        int adapterClipPosition = ClippingUtility.findIndexOfClipSequence((byte[])readBases, (byte[])StringUtil.stringToBytes((String)adapterSequence), (int)this.minAdapterMatch, (double)this.maxAdapterErrorRate);
        if (adapterClipPosition == -1) {
            adapterClipPosition = readString.length();
        } else if (adapterClipPosition == 0) {
            return new PolyAFinder.PolyARun(0, 0, 0);
        }
        PolyAFinder.PolyARun ret = this.getPolyARun(readString, adapterClipPosition);
        if (ret.isNoMatch() && adapterClipPosition < readString.length() && adapterClipPosition + this.dubiousAdapterMatchLength >= readString.length() && !(tryWithoutAdapter = this.getPolyARun(readString, readString.length())).isNoMatch()) {
            return tryWithoutAdapter;
        }
        return ret;
    }

    private PolyAFinder.PolyARun getPolyARun(String readBases, int adapterClipPosition) {
        int realAdapterClipPosition = adapterClipPosition < readBases.length() - 1 ? adapterClipPosition : -1;
        int minPolyABases = realAdapterClipPosition == -1 ? this.minPolyALengthNoAdapterMatch : Math.min(adapterClipPosition, this.minPolyALength);
        int numMisMatches = 0;
        int bestPolyARunStart = -1;
        double bestErrorRate = 1.0;
        for (int i = adapterClipPosition - 1; i >= 0; --i) {
            if (readBases.charAt(i) == A) {
                double errorRate = (double)numMisMatches / (double)(adapterClipPosition - i);
                if (adapterClipPosition - i < minPolyABases || !(errorRate <= this.maxPolyAErrorRate)) continue;
                bestPolyARunStart = i;
                bestErrorRate = errorRate;
                continue;
            }
            ++numMisMatches;
        }
        if (bestErrorRate <= this.maxPolyAErrorRate && adapterClipPosition - bestPolyARunStart >= minPolyABases) {
            return new PolyAFinder.PolyARun(bestPolyARunStart, adapterClipPosition - bestPolyARunStart, realAdapterClipPosition);
        }
        return new PolyAFinder.PolyARun(-1, 0, realAdapterClipPosition);
    }
}

