/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import htsjdk.samtools.util.IterableOnceIterator;
import htsjdk.samtools.util.PeekableIterator;
import java.util.Iterator;

public abstract class FilteredIterator<T>
extends IterableOnceIterator<T> {
    final PeekableIterator<T> it;
    boolean firstTime = true;

    protected FilteredIterator(Iterator<T> underlyingIterator) {
        this.it = new PeekableIterator(underlyingIterator);
    }

    public abstract boolean filterOut(T var1);

    private void skipUndesired() {
        while (this.it.hasNext() && this.filterOut(this.it.peek())) {
            this.it.next();
        }
    }

    private void maybeSkipFirstTime() {
        if (this.firstTime) {
            this.skipUndesired();
            this.firstTime = false;
        }
    }

    public void close() {
        this.it.close();
    }

    public boolean hasNext() {
        this.maybeSkipFirstTime();
        return this.it.hasNext();
    }

    public T next() {
        this.maybeSkipFirstTime();
        Object ret = this.it.next();
        this.skipUndesired();
        return (T)ret;
    }

    public void remove() {
        this.it.remove();
    }
}

