/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.StringUtil;
import java.util.Comparator;
import java.util.regex.Pattern;

public class IntervalTagComparator
implements Comparator<SAMRecord> {
    private final short tag;
    private final SAMSequenceDictionary dict;
    private static final Pattern colonPattern = Pattern.compile(":");
    private static final Pattern dashPattern = Pattern.compile("-");
    public static final char ENCODE_DELIMITER = '|';

    public IntervalTagComparator(String tag) {
        this.tag = SAMTagUtil.getSingleton().makeBinaryTag(tag);
        this.dict = null;
    }

    public IntervalTagComparator(String tag, SAMSequenceDictionary dict) {
        this.tag = SAMTagUtil.getSingleton().makeBinaryTag(tag);
        this.dict = dict;
    }

    public int compareOld(SAMRecord rec1, SAMRecord rec2) {
        Interval i1 = this.getIntervalForTag(rec1);
        Interval i2 = this.getIntervalForTag(rec2);
        return IntervalTagComparator.compare(i1, i2, this.dict);
    }

    @Override
    public int compare(SAMRecord rec1, SAMRecord rec2) {
        String[] rec1Split = this.getFirstSplit(rec1);
        String[] rec2Split = this.getFirstSplit(rec2);
        String rec1Contig = rec1Split[0];
        String rec2Contig = rec2Split[0];
        int result = 0;
        if (this.dict != null) {
            int seqIdx1 = this.dict.getSequenceIndex(rec1Contig);
            int seqIdx2 = this.dict.getSequenceIndex(rec2Contig);
            result = seqIdx1 - seqIdx2;
        } else {
            result = rec1Contig.compareTo(rec2Contig);
        }
        if (result == 0) {
            int[] posArray2;
            String pos1 = rec1Split[1];
            String pos2 = rec2Split[1];
            int[] posArray1 = this.parsePosition(pos1);
            result = posArray1[0] == (posArray2 = this.parsePosition(pos2))[0] ? posArray1[1] - posArray2[1] : posArray1[0] - posArray2[0];
            if (result == 0) {
                String n1 = rec1Split[3];
                String n2 = rec2Split[3];
                if (n1 != null && n2 != null) {
                    result = n1.compareTo(n2);
                }
            }
        }
        return result;
    }

    private String[] getFirstSplit(SAMRecord rec) {
        Object strIntervalRec = rec.getAttribute(this.tag);
        if (!(strIntervalRec instanceof String)) {
            throw new IllegalArgumentException(SAMTagUtil.getSingleton().makeStringTag(this.tag) + " does not have a String value");
        }
        String intervalString = (String)strIntervalRec;
        String[] result = new String[4];
        StringUtil.splitConcatenateExcessTokens((String)intervalString, (String[])result, (char)'|');
        return result;
    }

    private int[] parsePosition(String posString) {
        String[] posArray = new String[2];
        StringUtil.split((String)posString, (String[])posArray, (char)'-');
        int start = Integer.parseInt(posArray[0]);
        int end = Integer.parseInt(posArray[0]);
        if (posArray[1] != null) {
            end = Integer.parseInt(posArray[1]);
        }
        int[] result = new int[]{start, end};
        return result;
    }

    public static int compare(Interval i1, Interval i2, SAMSequenceDictionary dict) {
        int result = 0;
        if (dict != null) {
            int seqIdx1 = dict.getSequenceIndex(i1.getContig());
            int seqIdx2 = dict.getSequenceIndex(i2.getContig());
            result = seqIdx1 - seqIdx2;
        } else {
            result = i1.getContig().compareTo(i2.getContig());
        }
        if (result == 0 && (result = i1.getStart() == i2.getStart() ? i1.getEnd() - i2.getEnd() : i1.getStart() - i2.getStart()) == 0) {
            String n1 = i1.getName();
            String n2 = i2.getName();
            if (n1 != null && n2 != null) {
                result = n1.compareTo(n2);
            }
        }
        return result;
    }

    private Interval getIntervalForTag(SAMRecord rec) {
        Object strIntervalRec = rec.getAttribute(this.tag);
        if (!(strIntervalRec instanceof String)) {
            throw new IllegalArgumentException(SAMTagUtil.getSingleton().makeStringTag(this.tag) + " does not have a String value");
        }
        Interval result = IntervalTagComparator.fromString((String)strIntervalRec);
        return result;
    }

    public static Interval fromString(String intervalString) {
        String[] s = new String[4];
        StringUtil.splitConcatenateExcessTokens((String)intervalString, (String[])s, (char)'|');
        if (s.length == 1) {
            throw new IllegalArgumentException("This is not an interval " + intervalString + ", as there's no '" + '|' + "' delimiters");
        }
        String contig = s[0];
        Integer start = null;
        Integer end = null;
        Boolean negativeStrand = null;
        String name = null;
        String pos = s[1];
        String[] posArray = new String[2];
        StringUtil.split((String)pos, (String[])posArray, (char)'-');
        start = Integer.parseInt(posArray[0]);
        end = Integer.parseInt(posArray[0]);
        if (posArray[1] != null) {
            end = Integer.parseInt(posArray[1]);
        }
        if (s[2] != null) {
            if (s[2].equals("+")) {
                negativeStrand = false;
            }
            if (s[2].equals("-")) {
                negativeStrand = true;
            }
        }
        if (s[3] != null) {
            name = s[3];
        }
        Interval result = null;
        if (negativeStrand == null || name == null) {
            result = new Interval(contig, start.intValue(), end.intValue());
        }
        if (negativeStrand != null && name != null) {
            result = new Interval(contig, start.intValue(), end.intValue(), negativeStrand.booleanValue(), name);
        }
        return result;
    }

    public static Interval fromStringOld(String intervalString) {
        String[] s = intervalString.split(":", 4);
        if (s.length == 1) {
            throw new IllegalArgumentException("This is not an interval " + intervalString + ", as there's no ':' delimiters");
        }
        String contig = s[0];
        Integer start = null;
        Integer end = null;
        Boolean negativeStrand = null;
        String name = null;
        String pos = s[1];
        String[] posArray = pos.split("-");
        start = Integer.parseInt(posArray[0]);
        end = Integer.parseInt(posArray[0]);
        if (posArray[1] != null) {
            end = Integer.parseInt(posArray[1]);
        }
        if (s.length > 2) {
            if (s[2].equals("+")) {
                negativeStrand = false;
            }
            if (s[2].equals("-")) {
                negativeStrand = true;
            }
        }
        if (s.length > 3) {
            name = s[3];
        }
        Interval result = null;
        if (s.length == 2) {
            result = new Interval(contig, start.intValue(), end.intValue());
        }
        if (s.length > 2) {
            result = new Interval(contig, start.intValue(), end.intValue(), negativeStrand.booleanValue(), name);
        }
        return result;
    }

    public static String toString(Interval i) {
        String result = i.getContig() + '|' + i.getStart() + "-" + i.getEnd() + '|' + (i.isNegativeStrand() ? (char)'-' : '+') + '|' + (null == i.getName() ? Character.valueOf('.') : i.getName());
        return result;
    }
}

