/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class ErrorCheckingPrintStream
extends PrintStream {
    private String path = "unknown";
    private final ThreadLocal<Boolean> nestedFlush = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public ErrorCheckingPrintStream(OutputStream out) {
        super(out);
    }

    public ErrorCheckingPrintStream(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public ErrorCheckingPrintStream(OutputStream out, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
        super(out, autoFlush, encoding);
    }

    public ErrorCheckingPrintStream(String fileName) throws FileNotFoundException {
        super(fileName);
        this.path = fileName;
    }

    public ErrorCheckingPrintStream(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        super(fileName, csn);
        this.path = fileName;
    }

    public ErrorCheckingPrintStream(File file) throws FileNotFoundException {
        super(file);
        this.path = file.getAbsolutePath();
    }

    public ErrorCheckingPrintStream(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        super(file, csn);
        this.path = file.getAbsolutePath();
    }

    @Override
    public void flush() {
        if (this.nestedFlush.get().booleanValue()) {
            return;
        }
        try {
            this.nestedFlush.set(true);
            if (this.checkError()) {
                throw new RuntimeException("Exception writing file " + this.path);
            }
            super.flush();
        }
        finally {
            this.nestedFlush.set(false);
        }
    }

    @Override
    public void close() {
        if (this.checkError()) {
            throw new RuntimeException("Exception writing file " + this.path);
        }
        super.close();
    }

    public void setPath(String path) {
        this.path = path;
    }
}

